/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.slot.FluidFuelInventorySlot;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityHeatGenerator
extends TileEntityGenerator {
    public static final int MAX_FLUID = 24000;
    private static final double THERMAL_EFFICIENCY = 0.5;
    private static final FloatingLong MAX_PRODUCTION = FloatingLong.createConst((long)500L);
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getLava", "getLavaCapacity", "getLavaNeeded", "getLavaFilledPercentage"})
    public BasicFluidTank lavaTank;
    private FloatingLong producingEnergy = FloatingLong.ZERO;
    private double lastTransferLoss;
    private double lastEnvironmentLoss;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"})
    private BasicHeatCapacitor heatCapacitor;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"})
    private FluidFuelInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityHeatGenerator() {
        super((IBlockProvider)GeneratorsBlocks.HEAT_GENERATOR, ((FloatingLong)MekanismGeneratorsConfig.generators.heatGeneration.get()).multiply(2L));
    }

    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.lavaTank = BasicFluidTank.create((int)24000, fluidStack -> fluidStack.getFluid().func_207185_a((ITag)FluidTags.field_206960_b), (IContentsListener)this);
        builder.addTank((IExtendedFluidTank)this.lavaTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.fuelSlot = FluidFuelInventorySlot.forFuel((IExtendedFluidTank)this.lavaTank, stack -> ForgeHooks.getBurnTime((ItemStack)stack) / 20, (Int2ObjectFunction<FluidStack>)((Int2ObjectFunction)size -> new FluidStack((Fluid)Fluids.field_204547_b, size)), (IContentsListener)this, 17, 35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)this, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        return builder.build();
    }

    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.heatCapacitor = BasicHeatCapacitor.create((double)10.0, (double)5.0, (double)100.0, (DoubleSupplier)ambientTemperature, (IContentsListener)this);
        builder.addCapacitor((IHeatCapacitor)this.heatCapacitor);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillOrBurn();
        FloatingLong prev = this.getEnergyContainer().getEnergy().copyAsConst();
        this.heatCapacitor.handleHeat(this.getBoost().doubleValue());
        if (MekanismUtils.canFunction((TileEntityMekanism)this) && !this.getEnergyContainer().getNeeded().isZero()) {
            int fluidRate = MekanismGeneratorsConfig.generators.heatGenerationFluidRate.get();
            if (this.lavaTank.extract(fluidRate, Action.SIMULATE, AutomationType.INTERNAL).getAmount() == fluidRate) {
                this.setActive(true);
                this.lavaTank.extract(fluidRate, Action.EXECUTE, AutomationType.INTERNAL);
                this.heatCapacitor.handleHeat(((FloatingLong)MekanismGeneratorsConfig.generators.heatGeneration.get()).doubleValue());
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastTransferLoss = loss.getAdjacentTransfer();
        this.lastEnvironmentLoss = loss.getEnvironmentTransfer();
        this.producingEnergy = this.getEnergyContainer().getEnergy().subtract(prev);
    }

    private FloatingLong getBoost() {
        FloatingLong boost;
        if (this.field_145850_b == null) {
            return FloatingLong.ZERO;
        }
        FloatingLong passiveLavaAmount = (FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationLava.get();
        if (passiveLavaAmount.isZero()) {
            boost = FloatingLong.ZERO;
        } else {
            long lavaSides = Arrays.stream(EnumUtils.DIRECTIONS).filter(side -> {
                Optional fluidState = WorldUtils.getFluidState((IBlockReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(side));
                return fluidState.isPresent() && ((FluidState)fluidState.get()).func_206884_a((ITag)FluidTags.field_206960_b);
            }).count();
            if (this.func_195044_w().func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b)) {
                ++lavaSides;
            }
            boost = passiveLavaAmount.multiply(lavaSides);
        }
        if (this.field_145850_b.func_230315_m_().func_236040_e_()) {
            boost = boost.plusEqual((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationNether.get());
        }
        return boost;
    }

    public double getInverseInsulation(int capacitor, @Nullable Direction side) {
        return side == Direction.DOWN ? 0.0 : super.getInverseInsulation(capacitor, side);
    }

    @Nonnull
    public HeatAPI.HeatTransfer simulate() {
        double ambientTemp = this.ambientTemperature.getAsDouble();
        double temp = this.getTotalTemperature();
        double carnotEfficiency = 1.0 - Math.min(ambientTemp, temp) / Math.max(ambientTemp, temp);
        double heatLost = 0.5 * (temp - ambientTemp);
        this.heatCapacitor.handleHeat(-heatLost);
        this.getEnergyContainer().insert(MAX_PRODUCTION.min(FloatingLong.create((double)(Math.abs(heatLost) * carnotEfficiency))), Action.EXECUTE, AutomationType.INTERNAL);
        return super.simulate();
    }

    @Nullable
    public IHeatHandler getAdjacent(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            TileEntity adj = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177977_b());
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_HANDLER_CAPABILITY, (Direction)side.func_176734_d()).resolve().orElse(null);
        }
        return null;
    }

    @ComputerMethod(nameOverride="getProductionRate")
    public FloatingLong getProducingEnergy() {
        return this.producingEnergy;
    }

    @ComputerMethod(nameOverride="getTransferLoss")
    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    @ComputerMethod(nameOverride="getEnvironmentalLoss")
    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.lavaTank.getFluidAmount(), (long)this.lavaTank.getCapacity());
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getProducingEnergy, value -> {
            this.producingEnergy = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }
}

