/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import java.util.Random;
import mekanism.api.IEvaporationSolar;
import mekanism.api.RelativeSide;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityAdvancedSolarGenerator
extends TileEntitySolarGenerator
implements IBoundingBlock,
IEvaporationSolar {
    private final TileEntitySolarGenerator.SolarCheck[] solarChecks = new TileEntitySolarGenerator.SolarCheck[8];

    public TileEntityAdvancedSolarGenerator() {
        super((IBlockProvider)GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR, ((FloatingLong)MekanismGeneratorsConfig.generators.advancedSolarGeneration.get()).multiply(2L));
        this.addCapabilityResolver((ICapabilityResolver)BasicCapabilityResolver.constant((Capability)Capabilities.EVAPORATION_SOLAR_CAPABILITY, (Object)((Object)this)));
    }

    @Override
    protected RelativeSide[] getEnergySides() {
        return new RelativeSide[]{RelativeSide.FRONT, RelativeSide.BOTTOM};
    }

    @Override
    protected FloatingLong getConfiguredMax() {
        return (FloatingLong)MekanismGeneratorsConfig.generators.advancedSolarGeneration.get();
    }

    public void onPlace() {
        super.onPlace();
        if (this.field_145850_b != null) {
            BlockPos pos = this.func_174877_v();
            WorldUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177982_a(0, 1, 0), (BlockPos)pos);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    WorldUtils.makeBoundingBlock((IWorld)this.field_145850_b, (BlockPos)pos.func_177982_a(x, 2, z), (BlockPos)pos);
                }
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177984_a(), false);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(x, 2, z), false);
                }
            }
        }
    }

    @Override
    protected void recheckSettings() {
        if (this.field_145850_b == null) {
            return;
        }
        BlockPos topPos = this.field_174879_c.func_177981_b(2);
        this.solarCheck = new AdvancedSolarCheck(this.field_145850_b, topPos);
        float totalPeak = this.solarCheck.getPeakMultiplier();
        for (int i = 0; i < this.solarChecks.length; ++i) {
            this.solarChecks[i] = i < 3 ? new AdvancedSolarCheck(this.field_145850_b, topPos.func_177982_a(-1, 0, i - 1)) : (i == 3 ? new AdvancedSolarCheck(this.field_145850_b, topPos.func_177982_a(0, 0, -1)) : (i == 4 ? new AdvancedSolarCheck(this.field_145850_b, topPos.func_177982_a(0, 0, 1)) : new AdvancedSolarCheck(this.field_145850_b, topPos.func_177982_a(1, 0, i - 6))));
            totalPeak += this.solarChecks[i].getPeakMultiplier();
        }
        this.peakOutput = this.getConfiguredMax().multiply((double)(totalPeak / 9.0f));
    }

    @Override
    protected boolean checkCanSeeSun() {
        if (this.solarCheck == null) {
            return false;
        }
        this.solarCheck.recheckCanSeeSun();
        int count = this.solarCheck.canSeeSun() ? 1 : 0;
        for (TileEntitySolarGenerator.SolarCheck check : this.solarChecks) {
            check.recheckCanSeeSun();
            if (!check.canSeeSun()) continue;
            count = (byte)(count + 1);
        }
        return count > 4;
    }

    @Override
    public FloatingLong getProduction() {
        if (this.field_145850_b == null || this.solarCheck == null) {
            return FloatingLong.ZERO;
        }
        float brightness = this.getBrightnessMultiplier(this.field_145850_b);
        float generationMultiplier = this.solarCheck.getGenerationMultiplier();
        for (TileEntitySolarGenerator.SolarCheck check : this.solarChecks) {
            generationMultiplier += check.getGenerationMultiplier();
        }
        return this.getConfiguredMax().multiply((double)(brightness * generationMultiplier / 9.0f));
    }

    private static class AdvancedSolarCheck
    extends TileEntitySolarGenerator.SolarCheck {
        private final int recheckFrequency;
        private long lastCheckedSun;

        public AdvancedSolarCheck(World world, BlockPos pos) {
            super(world, pos);
            this.recheckFrequency = MathHelper.func_76136_a((Random)world.field_73012_v, (int)10, (int)30);
        }

        @Override
        public void recheckCanSeeSun() {
            BlockState state;
            BlockPos above;
            if (!this.world.func_230315_m_().func_218272_d() || this.world.func_175657_ab() >= 4) {
                this.canSeeSun = false;
                return;
            }
            long time = this.world.func_82737_E();
            if (time < this.lastCheckedSun + (long)this.recheckFrequency) {
                return;
            }
            this.lastCheckedSun = time;
            this.canSeeSun = this.world.func_204610_c(this.pos).func_206888_e() ? this.world.func_226660_f_(this.pos) : (this.world.func_226660_f_(above = this.pos.func_177984_a()) ? !(state = this.world.func_180495_p(above)).func_185904_a().func_76224_d() && state.func_200016_a((IBlockReader)this.world, above) <= 0 : false);
        }
    }
}

