/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network.to_server;

import java.util.function.BiFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PacketGeneratorsGuiButtonPress
implements IMekanismPacket {
    private final ClickedGeneratorsTileButton tileButton;
    private final int extra;
    private final BlockPos tilePosition;

    public PacketGeneratorsGuiButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public PacketGeneratorsGuiButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        INamedContainerProvider provider;
        TileEntityMekanism tile;
        ServerPlayerEntity player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, (BlockPos)this.tilePosition)) != null && (provider = this.tileButton.getProvider(tile, this.extra)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider, buf -> {
                buf.func_179255_a(this.tilePosition);
                buf.func_150787_b(this.extra);
            });
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.tileButton);
        buffer.func_179255_a(this.tilePosition);
        buffer.func_150787_b(this.extra);
    }

    public static PacketGeneratorsGuiButtonPress decode(PacketBuffer buffer) {
        return new PacketGeneratorsGuiButtonPress((ClickedGeneratorsTileButton)buffer.func_179257_a(ClickedGeneratorsTileButton.class), buffer.func_179259_c(), buffer.func_150792_a());
    }

    public static enum ClickedGeneratorsTileButton {
        TAB_MAIN((tile, extra) -> {
            if (tile instanceof TileEntityTurbineCasing) {
                return GeneratorsContainerTypes.INDUSTRIAL_TURBINE.getProvider((ILangEntry)GeneratorsLang.TURBINE, tile);
            }
            if (tile instanceof TileEntityFissionReactorCasing) {
                return GeneratorsContainerTypes.FISSION_REACTOR.getProvider((ILangEntry)GeneratorsLang.FISSION_REACTOR, tile);
            }
            return null;
        }),
        TAB_HEAT((tile, extra) -> GeneratorsContainerTypes.FUSION_REACTOR_HEAT.getProvider((ILangEntry)GeneratorsLang.HEAT_TAB, tile)),
        TAB_FUEL((tile, extra) -> GeneratorsContainerTypes.FUSION_REACTOR_FUEL.getProvider((ILangEntry)GeneratorsLang.FUEL_TAB, tile)),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityTurbineCasing) {
                return GeneratorsContainerTypes.TURBINE_STATS.getProvider((ILangEntry)GeneratorsLang.TURBINE_STATS, tile);
            }
            if (tile instanceof TileEntityFusionReactorController) {
                return GeneratorsContainerTypes.FUSION_REACTOR_STATS.getProvider((ILangEntry)GeneratorsLang.STATS_TAB, tile);
            }
            if (tile instanceof TileEntityFissionReactorCasing) {
                return GeneratorsContainerTypes.FISSION_REACTOR_STATS.getProvider((ILangEntry)GeneratorsLang.STATS_TAB, tile);
            }
            return null;
        });

        private final BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile;

        private ClickedGeneratorsTileButton(BiFunction<TileEntityMekanism, Integer, INamedContainerProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public INamedContainerProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }
}

