/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.generators.client.gui.GuiFusionReactorInfo;
import mekanism.generators.client.gui.element.GuiFusionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.text.ITextComponent;

public class GuiFusionReactorHeat
extends GuiFusionReactorInfo {
    private static final double MAX_LEVEL = 5.0E8;

    public GuiFusionReactorHeat(EmptyTileContainer<TileEntityFusionReactorController> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.func_230480_a_((Widget)new GuiEnergyTab((IGuiWrapper)this, () -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            return Arrays.asList(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((IEnergyContainer)multiblock.energyContainer)}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.getPassiveGeneration(false, true))}));
        }));
        this.func_230480_a_((Widget)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)Fluids.field_204547_b, (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL);
            }

            public double getLevel() {
                return ((FusionReactorMultiblockData)((TileEntityFusionReactorController)GuiFusionReactorHeat.this.tile).getMultiblock()).getLastPlasmaTemp();
            }

            public double getScaledLevel() {
                return Math.min(1.0, this.getLevel() / 5.0E8);
            }

            public ITextComponent getText() {
                return GeneratorsLang.REACTOR_PLASMA.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)this.getLevel(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)});
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 7, 50));
        this.func_230480_a_((Widget)new GuiProgress(() -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            return multiblock.getLastPlasmaTemp() > multiblock.getLastCaseTemp();
        }, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 29, 76));
        this.func_230480_a_((Widget)new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getBaseFluidTexture((Fluid)Fluids.field_204547_b, (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL);
            }

            public double getLevel() {
                return ((FusionReactorMultiblockData)((TileEntityFusionReactorController)GuiFusionReactorHeat.this.tile).getMultiblock()).getLastCaseTemp();
            }

            public double getScaledLevel() {
                return Math.min(1.0, this.getLevel() / 5.0E8);
            }

            public ITextComponent getText() {
                return GeneratorsLang.REACTOR_CASE.translate(new Object[]{MekanismUtils.getTemperatureDisplay((double)this.getLevel(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)});
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 61, 50));
        this.func_230480_a_((Widget)new GuiProgress(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).getCaseTemp() > 0.0, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 83, 61));
        this.func_230480_a_((Widget)new GuiProgress(() -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            return multiblock.getCaseTemp() > 0.0 && !multiblock.waterTank.isEmpty() && multiblock.steamTank.getStored() < multiblock.steamTank.getCapacity();
        }, ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 83, 91));
        this.func_230480_a_((Widget)new GuiFluidGauge(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).waterTank, () -> ((TileEntityFusionReactorController)this.tile).getFluidTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 115, 84));
        this.func_230480_a_((Widget)new GuiGasGauge(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).steamTank, () -> ((TileEntityFusionReactorController)this.tile).getGasTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 151, 84));
        this.func_230480_a_((Widget)new GuiEnergyGauge(((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).energyContainer, GaugeType.SMALL, (IGuiWrapper)this, 115, 46));
        this.func_230480_a_((Widget)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.FUEL));
        this.func_230480_a_((Widget)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.STAT));
    }

    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawTitleText(matrix, (ITextComponent)GeneratorsLang.FUSION_REACTOR.translate(new Object[0]), this.field_238743_q_);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

