/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.common.TileGeneric;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class TickScheduler {
    private static final Queue<TileGeneric> toTick = new ConcurrentLinkedDeque<TileGeneric>();

    private TickScheduler() {
    }

    public static void schedule(TileGeneric tile) {
        World world = tile.func_145831_w();
        if (world != null && !world.field_72995_K && !tile.scheduled.getAndSet(true)) {
            toTick.add(tile);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        TileGeneric tile;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        while ((tile = toTick.poll()) != null) {
            tile.scheduled.set(false);
            if (tile.func_145837_r()) continue;
            World world = tile.func_145831_w();
            BlockPos pos = tile.func_174877_v();
            if (world == null || pos == null || !world.isAreaLoaded(pos, 0) || world.func_175625_s(pos) != tile) continue;
            world.func_205220_G_().func_205360_a(pos, (Object)tile.func_195044_w().func_177230_c(), 0);
        }
    }
}

