/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.media.items.ItemPrintout;
import dan200.computercraft.shared.peripheral.printer.BlockPrinter;
import dan200.computercraft.shared.peripheral.printer.ContainerPrinter;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DefaultSidedInventory;
import dan200.computercraft.shared.util.SidedCaps;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.LockCode;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public final class TilePrinter
extends TileGeneric
implements DefaultSidedInventory,
INameable,
INamedContainerProvider {
    private static final String NBT_NAME = "CustomName";
    private static final String NBT_PRINTING = "Printing";
    private static final String NBT_PAGE_TITLE = "PageTitle";
    static final int SLOTS = 13;
    private static final int[] BOTTOM_SLOTS = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] TOP_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SIDE_SLOTS = new int[]{0};
    ITextComponent customName;
    private LockCode lockCode = LockCode.field_180162_a;
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)13, (Object)ItemStack.field_190927_a);
    private final SidedCaps<IItemHandler> itemHandlerCaps = SidedCaps.ofNullable(facing -> facing == null ? new InvWrapper((IInventory)this) : new SidedInvWrapper((ISidedInventory)this, facing));
    private LazyOptional<IPeripheral> peripheralCap;
    private final Terminal page = new Terminal(25, 21);
    private String pageTitle = "";
    private boolean printing = false;

    public TilePrinter(TileEntityType<TilePrinter> type) {
        super(type);
    }

    @Override
    public void destroy() {
        this.ejectContents();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCaps.invalidate();
        this.peripheralCap = CapabilityUtil.invalidate(this.peripheralCap);
    }

    @Override
    public boolean isUsable(PlayerEntity player) {
        return super.isUsable(player) && LockableTileEntity.func_213905_a((PlayerEntity)player, (LockCode)this.lockCode, (ITextComponent)this.func_145748_c_());
    }

    @Override
    @Nonnull
    public ActionResultType onActivate(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_213453_ef()) {
            return ActionResultType.PASS;
        }
        if (!this.func_145831_w().field_72995_K && this.isUsable(player)) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
        }
        return ActionResultType.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.customName = nbt.func_74764_b(NBT_NAME) ? ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i(NBT_NAME)) : null;
        Terminal terminal = this.page;
        synchronized (terminal) {
            this.printing = nbt.func_74767_n(NBT_PRINTING);
            this.pageTitle = nbt.func_74779_i(NBT_PAGE_TITLE);
            this.page.readFromNBT(nbt);
        }
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        this.lockCode = LockCode.func_180158_b((CompoundNBT)nbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        if (this.customName != null) {
            nbt.func_74778_a(NBT_NAME, ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        Terminal terminal = this.page;
        synchronized (terminal) {
            nbt.func_74757_a(NBT_PRINTING, this.printing);
            nbt.func_74778_a(NBT_PAGE_TITLE, this.pageTitle);
            this.page.writeToNBT(nbt);
        }
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.inventory);
        this.lockCode.func_180157_a(nbt);
        return super.func_189515_b(nbt);
    }

    boolean isPrinting() {
        return this.printing;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        ItemStack result = (ItemStack)this.inventory.get(slot);
        this.inventory.set(slot, (Object)ItemStack.field_190927_a);
        this.func_70296_d();
        this.updateBlockState();
        return result;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        ItemStack stack = (ItemStack)this.inventory.get(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() <= count) {
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return stack;
        }
        ItemStack part = stack.func_77979_a(count);
        if (((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            this.inventory.set(slot, (Object)ItemStack.field_190927_a);
            this.updateBlockState();
        }
        this.func_70296_d();
        return part;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.func_70296_d();
        this.updateBlockState();
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
        this.updateBlockState();
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return TilePrinter.isInk(stack);
        }
        if (slot >= TOP_SLOTS[0] && slot <= TOP_SLOTS[TOP_SLOTS.length - 1]) {
            return TilePrinter.isPaper(stack);
        }
        return false;
    }

    public boolean func_70300_a(@Nonnull PlayerEntity playerEntity) {
        return this.isUsable(playerEntity);
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull Direction side) {
        switch (side) {
            case DOWN: {
                return BOTTOM_SLOTS;
            }
            case UP: {
                return TOP_SLOTS;
            }
        }
        return SIDE_SLOTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Terminal getCurrentPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            return this.printing ? this.page : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNewPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            if (!this.canInputPage()) {
                return false;
            }
            if (this.printing && !this.outputPage()) {
                return false;
            }
            return this.inputPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endCurrentPage() {
        Terminal terminal = this.page;
        synchronized (terminal) {
            return this.printing && this.outputPage();
        }
    }

    int getInkLevel() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        return TilePrinter.isInk(inkStack) ? inkStack.func_190916_E() : 0;
    }

    int getPaperLevel() {
        int count = 0;
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = (ItemStack)this.inventory.get(i);
            if (!TilePrinter.isPaper(paperStack)) continue;
            count += paperStack.func_190916_E();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPageTitle(String title) {
        Terminal terminal = this.page;
        synchronized (terminal) {
            if (this.printing) {
                this.pageTitle = title;
            }
        }
    }

    static boolean isInk(@Nonnull ItemStack stack) {
        return ColourUtils.getStackColour(stack) != null;
    }

    static boolean isPaper(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151121_aF || item instanceof ItemPrintout && ((ItemPrintout)item).getType() == ItemPrintout.Type.PAGE;
    }

    private boolean canInputPage() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        return !inkStack.func_190926_b() && TilePrinter.isInk(inkStack) && this.getPaperLevel() > 0;
    }

    private boolean inputPage() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        DyeColor dye = ColourUtils.getStackColour(inkStack);
        if (dye == null) {
            return false;
        }
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = (ItemStack)this.inventory.get(i);
            if (paperStack.func_190926_b() || !TilePrinter.isPaper(paperStack)) continue;
            this.page.setTextColour(dye.func_196059_a());
            this.page.clear();
            if (paperStack.func_77973_b() instanceof ItemPrintout) {
                this.pageTitle = ItemPrintout.getTitle(paperStack);
                String[] text = ItemPrintout.getText(paperStack);
                String[] textColour = ItemPrintout.getColours(paperStack);
                for (int y = 0; y < this.page.getHeight(); ++y) {
                    this.page.setLine(y, text[y], textColour[y], "");
                }
            } else {
                this.pageTitle = "";
            }
            this.page.setCursorPos(0, 0);
            inkStack.func_190918_g(1);
            if (inkStack.func_190926_b()) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
            paperStack.func_190918_g(1);
            if (paperStack.func_190926_b()) {
                this.inventory.set(i, (Object)ItemStack.field_190927_a);
                this.updateBlockState();
            }
            this.func_70296_d();
            this.printing = true;
            return true;
        }
        return false;
    }

    private boolean outputPage() {
        int height = this.page.getHeight();
        String[] lines = new String[height];
        String[] colours = new String[height];
        for (int i = 0; i < height; ++i) {
            lines[i] = this.page.getLine(i).toString();
            colours[i] = this.page.getTextColourLine(i).toString();
        }
        ItemStack stack = ItemPrintout.createSingleFromTitleAndText(this.pageTitle, lines, colours);
        for (int slot : BOTTOM_SLOTS) {
            if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) continue;
            this.func_70299_a(slot, stack);
            this.printing = false;
            return true;
        }
        return false;
    }

    private void ejectContents() {
        for (int i = 0; i < 13; ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b()) continue;
            this.func_70299_a(i, ItemStack.field_190927_a);
            WorldUtil.dropItemStack(stack, this.func_145831_w(), Vector3d.func_237491_b_((Vector3i)this.func_174877_v()).func_72441_c(0.5, 0.75, 0.5));
        }
    }

    private void updateBlockState() {
        ItemStack stack;
        int i;
        boolean top = false;
        boolean bottom = false;
        for (i = 1; i < 7; ++i) {
            stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b() || !TilePrinter.isPaper(stack)) continue;
            top = true;
            break;
        }
        for (i = 7; i < 13; ++i) {
            stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b() || !TilePrinter.isPaper(stack)) continue;
            bottom = true;
            break;
        }
        this.updateBlockState(top, bottom);
    }

    private void updateBlockState(boolean top, boolean bottom) {
        if (this.field_145846_f || this.field_145850_b == null) {
            return;
        }
        BlockState state = this.func_195044_w();
        if ((Boolean)state.func_177229_b((Property)BlockPrinter.TOP) == top & (Boolean)state.func_177229_b((Property)BlockPrinter.BOTTOM) == bottom) {
            return;
        }
        this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)((BlockState)state.func_206870_a((Property)BlockPrinter.TOP, (Comparable)Boolean.valueOf(top))).func_206870_a((Property)BlockPrinter.BOTTOM, (Comparable)Boolean.valueOf(bottom)));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCaps.get(facing).cast();
        }
        if (capability == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> new PrinterPeripheral(this));
            }
            return this.peripheralCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public ITextComponent func_145748_c_() {
        return super.func_145748_c_();
    }

    @Nonnull
    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new ContainerPrinter(id, inventory, this);
    }
}

