/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class MonitorWatcher {
    private static final Queue<TileMonitor> watching = new ArrayDeque<TileMonitor>();
    private static final Queue<PlayerUpdate> playerUpdates = new ArrayDeque<PlayerUpdate>();

    private MonitorWatcher() {
    }

    static void enqueue(TileMonitor monitor) {
        if (monitor.enqueued) {
            return;
        }
        monitor.enqueued = true;
        monitor.cached = null;
        watching.add(monitor);
    }

    @SubscribeEvent
    public static void onWatch(ChunkWatchEvent.Watch event) {
        ChunkPos chunkPos = event.getPos();
        Chunk chunk = event.getWorld().func_72863_F().func_225313_a(chunkPos.field_77276_a, chunkPos.field_77275_b);
        if (chunk == null) {
            return;
        }
        for (TileEntity te : chunk.func_177434_r().values()) {
            TileMonitor monitor;
            ServerMonitor serverMonitor;
            if (!(te instanceof TileMonitor) || (serverMonitor = MonitorWatcher.getMonitor(monitor = (TileMonitor)te)) == null || monitor.enqueued) continue;
            playerUpdates.add(new PlayerUpdate(event.getPlayer(), monitor));
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        TileMonitor tile;
        boolean obeyLimit;
        PlayerUpdate playerUpdate;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        while ((playerUpdate = playerUpdates.poll()) != null) {
            ServerPlayerEntity player;
            ServerMonitor monitor;
            TileMonitor tile2 = playerUpdate.monitor;
            if (tile2.enqueued || tile2.func_145837_r() || (monitor = MonitorWatcher.getMonitor(tile2)) == null || !(player = playerUpdate.player).func_70089_S() || player.func_71121_q() != tile2.func_145831_w()) continue;
            NetworkHandler.sendToPlayer((PlayerEntity)playerUpdate.player, new MonitorClientMessage(tile2.func_174877_v(), MonitorWatcher.getState(tile2, monitor)));
        }
        long limit = ComputerCraft.monitorBandwidth;
        boolean bl = obeyLimit = limit > 0L;
        while (!(obeyLimit && limit <= 0L || (tile = watching.poll()) == null)) {
            Chunk chunk;
            tile.enqueued = false;
            ServerMonitor monitor = MonitorWatcher.getMonitor(tile);
            if (monitor == null) continue;
            BlockPos pos = tile.func_174877_v();
            World world = tile.func_145831_w();
            if (!(world instanceof ServerWorld) || !((ServerWorld)world).func_72863_F().field_217237_a.func_219097_a((chunk = world.func_175726_f(pos)).func_76632_l(), false).findAny().isPresent()) continue;
            TerminalState state = MonitorWatcher.getState(tile, monitor);
            NetworkHandler.sendToAllTracking(new MonitorClientMessage(pos, state), chunk);
            limit -= (long)state.size();
        }
    }

    private static ServerMonitor getMonitor(TileMonitor monitor) {
        return !monitor.func_145837_r() && monitor.getXIndex() == 0 && monitor.getYIndex() == 0 ? monitor.getCachedServerMonitor() : null;
    }

    private static TerminalState getState(TileMonitor tile, ServerMonitor monitor) {
        TerminalState state = tile.cached;
        if (state == null) {
            state = tile.cached = monitor.write();
        }
        return state;
    }

    private static final class PlayerUpdate {
        final ServerPlayerEntity player;
        final TileMonitor monitor;

        private PlayerUpdate(ServerPlayerEntity player, TileMonitor monitor) {
            this.player = player;
            this.monitor = monitor;
        }
    }
}

