/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.base.Objects;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public class TileCable
extends TileGeneric {
    private static final String NBT_PERIPHERAL_ENABLED = "PeirpheralAccess";
    private boolean invalidPeripheral;
    private boolean peripheralAccessAllowed;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(this::queueRefreshPeripheral);
    private boolean destroyed = false;
    private Direction modemDirection = Direction.NORTH;
    private boolean hasModemDirection = false;
    private boolean connectionsFormed = false;
    private final WiredModemElement cable = new CableElement();
    private LazyOptional<IWiredElement> elementCap;
    private final IWiredNode node = this.cable.getNode();
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule(this)), this.cable){

        @Override
        @Nonnull
        protected WiredModemLocalPeripheral getLocalPeripheral() {
            return TileCable.this.peripheral;
        }

        @Override
        @Nonnull
        public Vector3d getPosition() {
            return Vector3d.func_237489_a_((Vector3i)TileCable.this.func_174877_v().func_177972_a(TileCable.this.modemDirection));
        }

        @Override
        @Nonnull
        public Object getTarget() {
            return TileCable.this;
        }
    };
    private LazyOptional<IPeripheral> modemCap;
    private final NonNullConsumer<LazyOptional<IWiredElement>> connectedNodeChanged = x -> this.connectionsChanged();

    public TileCable(TileEntityType<? extends TileCable> type) {
        super(type);
    }

    private void onRemove() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.modem.destroy();
            this.onRemove();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.onRemove();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onRemove();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        this.modemCap = CapabilityUtil.invalidate(this.modemCap);
    }

    public void onLoad() {
        super.onLoad();
        TickScheduler.schedule(this);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.hasModemDirection = false;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)this.func_195044_w().func_177230_c(), 0);
        }
    }

    private void refreshDirection() {
        if (this.hasModemDirection) {
            return;
        }
        this.hasModemDirection = true;
        this.modemDirection = ((CableModemVariant)((Object)this.func_195044_w().func_177229_b(BlockCable.MODEM))).getFacing();
    }

    @Nullable
    private Direction getMaybeDirection() {
        this.refreshDirection();
        return this.modemDirection;
    }

    @Nonnull
    private Direction getDirection() {
        this.refreshDirection();
        return this.modemDirection == null ? Direction.NORTH : this.modemDirection;
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        Direction dir = this.getDirection();
        if (neighbour.equals((Object)this.func_174877_v().func_177972_a(dir)) && this.hasModem() && !this.func_195044_w().func_196955_c((IWorldReader)this.func_145831_w(), this.func_174877_v())) {
            if (this.hasCable()) {
                Block.func_180635_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)new ItemStack((IItemProvider)Registry.ModItems.WIRED_MODEM.get()));
                this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a(BlockCable.MODEM, (Comparable)((Object)CableModemVariant.None)));
                this.modemChanged();
                this.connectionsChanged();
            } else {
                Block.func_180635_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)new ItemStack((IItemProvider)Registry.ModItems.WIRED_MODEM.get()));
                this.func_145831_w().func_217377_a(this.func_174877_v(), false);
            }
            return;
        }
        this.onNeighbourTileEntityChange(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        super.onNeighbourTileEntityChange(neighbour);
        if (!this.field_145850_b.field_72995_K && this.peripheralAccessAllowed) {
            Direction facing = this.getDirection();
            if (this.func_174877_v().func_177972_a(facing).equals((Object)neighbour)) {
                this.queueRefreshPeripheral();
            }
        }
    }

    private void queueRefreshPeripheral() {
        if (this.invalidPeripheral) {
            return;
        }
        this.invalidPeripheral = true;
        TickScheduler.schedule(this);
    }

    private void refreshPeripheral() {
        this.invalidPeripheral = false;
        if (this.field_145850_b != null && !this.func_145837_r() && this.peripheral.attach(this.field_145850_b, this.func_174877_v(), this.getDirection())) {
            this.updateConnectedPeripherals();
        }
    }

    @Override
    @Nonnull
    public ActionResultType onActivate(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player.func_213453_ef() || !player.func_175142_cm()) {
            return ActionResultType.PASS;
        }
        if (!this.canAttachPeripheral()) {
            return ActionResultType.FAIL;
        }
        if (this.func_145831_w().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        String oldName = this.peripheral.getConnectedName();
        this.togglePeripheralAccess();
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equal((Object)newName, (Object)oldName)) {
            if (oldName != null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.computercraft.wired_modem.peripheral_disconnected", new Object[]{ChatHelpers.copy(oldName)}), false);
            }
            if (newName != null) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.computercraft.wired_modem.peripheral_connected", new Object[]{ChatHelpers.copy(newName)}), false);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.peripheralAccessAllowed = nbt.func_74767_n(NBT_PERIPHERAL_ENABLED);
        this.peripheral.read(nbt, "");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74757_a(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        this.peripheral.write(nbt, "");
        return super.func_189515_b(nbt);
    }

    private void updateBlockState() {
        CableModemVariant newVariant;
        BlockState state = this.func_195044_w();
        CableModemVariant oldVariant = (CableModemVariant)((Object)state.func_177229_b(BlockCable.MODEM));
        if (oldVariant != (newVariant = CableModemVariant.from(oldVariant.getFacing(), this.modem.getModemState().isOpen(), this.peripheralAccessAllowed))) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a(BlockCable.MODEM, (Comparable)((Object)newVariant)));
        }
    }

    @Override
    public void blockTick() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        Direction oldDirection = this.modemDirection;
        this.refreshDirection();
        if (this.modemDirection != oldDirection) {
            this.modemCap = CapabilityUtil.invalidate(this.modemCap);
            this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        }
        if (this.invalidPeripheral) {
            this.refreshPeripheral();
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                this.peripheral.attach(this.field_145850_b, this.field_174879_c, this.modemDirection);
                this.updateConnectedPeripherals();
            }
        }
    }

    void connectionsChanged() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        BlockState state = this.func_195044_w();
        World world = this.func_145831_w();
        BlockPos current = this.func_174877_v();
        for (Direction facing : DirectionUtil.FACINGS) {
            LazyOptional<IWiredElement> element;
            BlockPos offset = current.func_177972_a(facing);
            if (!world.isAreaLoaded(offset, 0) || !(element = ComputerCraftAPI.getWiredElementAt((IBlockReader)world, offset, facing.func_176734_d())).isPresent()) continue;
            element.addListener(this.connectedNodeChanged);
            IWiredNode node = ((IWiredElement)element.orElseThrow(NullPointerException::new)).getNode();
            if (BlockCable.canConnectIn(state, facing)) {
                this.node.connectTo(node);
                continue;
            }
            if (this.node.getNetwork() != node.getNetwork()) continue;
            this.node.disconnectFrom(node);
        }
    }

    void modemChanged() {
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.canAttachPeripheral() && this.peripheralAccessAllowed) {
            this.peripheralAccessAllowed = false;
            this.peripheral.detach();
            this.node.updatePeripherals(Collections.emptyMap());
            this.func_70296_d();
            this.updateBlockState();
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            this.peripheral.attach(this.field_145850_b, this.func_174877_v(), this.getDirection());
            if (!this.peripheral.hasPeripheral()) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.peripheral.toMap());
        } else {
            this.peripheral.detach();
            this.peripheralAccessAllowed = false;
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.peripheral.toMap();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == Capabilities.CAPABILITY_WIRED_ELEMENT) {
            if (this.destroyed || !BlockCable.canConnectIn(this.func_195044_w(), side)) {
                return LazyOptional.empty();
            }
            if (this.elementCap == null) {
                this.elementCap = LazyOptional.of(() -> this.cable);
            }
            return this.elementCap.cast();
        }
        if (capability == Capabilities.CAPABILITY_PERIPHERAL) {
            this.refreshDirection();
            if (side != null && this.getMaybeDirection() != side) {
                return LazyOptional.empty();
            }
            if (this.modemCap == null) {
                this.modemCap = LazyOptional.of(() -> this.modem);
            }
            return this.modemCap.cast();
        }
        return super.getCapability(capability, side);
    }

    boolean hasCable() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)BlockCable.CABLE);
    }

    public boolean hasModem() {
        return this.func_195044_w().func_177229_b(BlockCable.MODEM) != CableModemVariant.None;
    }

    private boolean canAttachPeripheral() {
        return this.hasCable() && this.hasModem();
    }

    private class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        @Override
        @Nonnull
        public World getWorld() {
            return TileCable.this.func_145831_w();
        }

        @Override
        @Nonnull
        public Vector3d getPosition() {
            return Vector3d.func_237489_a_((Vector3i)TileCable.this.func_174877_v());
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            TileCable.this.modem.attachPeripheral(name, peripheral);
        }

        @Override
        protected void detachPeripheral(String name) {
            TileCable.this.modem.detachPeripheral(name);
        }
    }
}

