/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralProvider;
import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public final class Peripherals {
    private static final Collection<IPeripheralProvider> providers = new LinkedHashSet<IPeripheralProvider>();

    private Peripherals() {
    }

    public static synchronized void register(@Nonnull IPeripheralProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    @Nullable
    public static IPeripheral getPeripheral(World world, BlockPos pos, Direction side, NonNullConsumer<Object> invalidate) {
        return World.func_175701_a((BlockPos)pos) && !world.field_72995_K ? Peripherals.getPeripheralAt(world, pos, side, invalidate) : null;
    }

    @Nullable
    private static IPeripheral getPeripheralAt(World world, BlockPos pos, Direction side, NonNullConsumer<? super Object> invalidate) {
        LazyOptional peripheral;
        TileEntity block = world.func_175625_s(pos);
        if (block != null && (peripheral = block.getCapability(Capabilities.CAPABILITY_PERIPHERAL, side)).isPresent()) {
            return (IPeripheral)CapabilityUtil.unwrap(peripheral, invalidate);
        }
        for (IPeripheralProvider peripheralProvider : providers) {
            try {
                LazyOptional<IPeripheral> peripheral2 = peripheralProvider.getPeripheral(world, pos, side);
                if (!peripheral2.isPresent()) continue;
                return CapabilityUtil.unwrap(peripheral2, invalidate);
            }
            catch (Exception e) {
                ComputerCraft.log.error("Peripheral provider " + peripheralProvider + " errored.", (Throwable)e);
            }
        }
        return GenericPeripheralProvider.getPeripheral(world, pos, side, invalidate);
    }
}

