/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.websocket;

import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.websocket.Websocket;
import dan200.computercraft.core.tracking.TrackingField;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;

public class WebsocketHandler
extends SimpleChannelInboundHandler<Object> {
    private final Websocket websocket;
    private final WebSocketClientHandshaker handshaker;
    private final Options options;

    public WebsocketHandler(Websocket websocket, WebSocketClientHandshaker handshaker, Options options) {
        this.handshaker = handshaker;
        this.websocket = websocket;
        this.options = options;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.handshaker.handshake(ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.websocket.close(-1, "Websocket is inactive");
        super.channelInactive(ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (this.websocket.isClosed()) {
            return;
        }
        if (!this.handshaker.isHandshakeComplete()) {
            this.handshaker.finishHandshake(ctx.channel(), (FullHttpResponse)msg);
            this.websocket.success(ctx.channel(), this.options);
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
        }
        WebSocketFrame frame = (WebSocketFrame)msg;
        if (frame instanceof TextWebSocketFrame) {
            String data = ((TextWebSocketFrame)frame).text();
            this.websocket.environment().addTrackingChange(TrackingField.WEBSOCKET_INCOMING, data.length());
            this.websocket.environment().queueEvent("websocket_message", this.websocket.address(), data, false);
        } else if (frame instanceof BinaryWebSocketFrame) {
            byte[] converted = NetworkUtils.toBytes(frame.content());
            this.websocket.environment().addTrackingChange(TrackingField.WEBSOCKET_INCOMING, converted.length);
            this.websocket.environment().queueEvent("websocket_message", this.websocket.address(), converted, true);
        } else if (frame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)frame;
            this.websocket.close(closeFrame.statusCode(), closeFrame.reasonText());
        } else if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
        String message = NetworkUtils.toFriendlyError(cause);
        if (this.handshaker.isHandshakeComplete()) {
            this.websocket.close(-1, message);
        } else {
            this.websocket.failure(message);
        }
    }
}

