/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.render.TileEntityMonitorRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL31;

class MonitorTextureBufferShader {
    public static final int UNIFORM_SIZE = 276;
    static final int TEXTURE_INDEX = 33987;
    private static final FloatBuffer MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static int uniformMv;
    private static int uniformFont;
    private static int uniformTbo;
    private static int uniformMonitor;
    private static int uniformCursorBlink;
    private static boolean initialised;
    private static boolean ok;
    private static int program;

    MonitorTextureBufferShader() {
    }

    static void setupUniform(Matrix4f transform, int tboUniform) {
        MATRIX_BUFFER.rewind();
        transform.func_195879_b(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        RenderSystem.glUniformMatrix4((int)uniformMv, (boolean)false, (FloatBuffer)MATRIX_BUFFER);
        GL31.glBindBufferBase((int)35345, (int)uniformMonitor, (int)tboUniform);
        int cursorAlpha = FrameInfo.getGlobalCursorBlink() ? 1 : 0;
        RenderSystem.glUniform1i((int)uniformCursorBlink, (int)cursorAlpha);
    }

    static boolean use() {
        if (initialised) {
            if (ok) {
                GlStateManager.func_227723_g_((int)program);
            }
            return ok;
        }
        ok = MonitorTextureBufferShader.load();
        if (ok) {
            GL20.glUseProgram((int)program);
            RenderSystem.glUniform1i((int)uniformFont, (int)0);
            RenderSystem.glUniform1i((int)uniformTbo, (int)3);
        }
        return ok;
    }

    private static boolean load() {
        initialised = true;
        try {
            int vertexShader = MonitorTextureBufferShader.loadShader(35633, "assets/computercraft/shaders/monitor.vert");
            int fragmentShader = MonitorTextureBufferShader.loadShader(35632, "assets/computercraft/shaders/monitor.frag");
            program = GlStateManager.func_227743_n_();
            GlStateManager.func_227704_d_((int)program, (int)vertexShader);
            GlStateManager.func_227704_d_((int)program, (int)fragmentShader);
            GL20.glBindAttribLocation((int)program, (int)0, (CharSequence)"v_pos");
            GlStateManager.func_227729_i_((int)program);
            boolean ok = GlStateManager.func_227691_c_((int)program, (int)35714) != 0;
            String log = GlStateManager.func_227736_k_((int)program, (int)Short.MAX_VALUE).trim();
            if (!Strings.isNullOrEmpty((String)log)) {
                ComputerCraft.log.warn("Problems when linking monitor shader: {}", (Object)log);
            }
            GL20.glDetachShader((int)program, (int)vertexShader);
            GL20.glDetachShader((int)program, (int)fragmentShader);
            GlStateManager.func_227703_d_((int)vertexShader);
            GlStateManager.func_227703_d_((int)fragmentShader);
            if (!ok) {
                return false;
            }
            uniformMv = MonitorTextureBufferShader.getUniformLocation(program, "u_mv");
            uniformFont = MonitorTextureBufferShader.getUniformLocation(program, "u_font");
            uniformTbo = MonitorTextureBufferShader.getUniformLocation(program, "u_tbo");
            uniformMonitor = GL31.glGetUniformBlockIndex((int)program, (CharSequence)"u_monitor");
            if (uniformMonitor == -1) {
                throw new IllegalStateException("Could not find uniformMonitor uniform.");
            }
            uniformCursorBlink = MonitorTextureBufferShader.getUniformLocation(program, "u_cursorBlink");
            ComputerCraft.log.info("Loaded monitor shader.");
            return true;
        }
        catch (Exception e) {
            ComputerCraft.log.error("Cannot load monitor shaders", (Throwable)e);
            return false;
        }
    }

    private static int loadShader(int kind, String path) {
        InputStream stream = TileEntityMonitorRenderer.class.getClassLoader().getResourceAsStream(path);
        if (stream == null) {
            throw new IllegalArgumentException("Cannot find " + path);
        }
        String contents = TextureUtil.func_225687_b_((InputStream)stream);
        int shader = GlStateManager.func_227711_e_((int)kind);
        GlStateManager.func_227654_a_((int)shader, (CharSequence)contents);
        GlStateManager.func_227717_f_((int)shader);
        boolean ok = GlStateManager.func_227712_e_((int)shader, (int)35713) != 0;
        String log = GlStateManager.func_227733_j_((int)shader, (int)Short.MAX_VALUE).trim();
        if (!Strings.isNullOrEmpty((String)log)) {
            ComputerCraft.log.warn("Problems when loading monitor shader {}: {}", (Object)path, (Object)log);
        }
        if (!ok) {
            throw new IllegalStateException("Cannot compile shader " + path);
        }
        return shader;
    }

    private static int getUniformLocation(int program, String name) {
        int uniform = GlStateManager.func_227680_b_((int)program, (CharSequence)name);
        if (uniform == -1) {
            throw new IllegalStateException("Cannot find uniform " + name);
        }
        return uniform;
    }

    public static void setTerminalData(ByteBuffer buffer, Terminal terminal) {
        int width = terminal.getWidth();
        int height = terminal.getHeight();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            TextBuffer text = terminal.getLine(y);
            TextBuffer textColour = terminal.getTextColourLine(y);
            TextBuffer background = terminal.getBackgroundColourLine(y);
            for (int x = 0; x < width; ++x) {
                buffer.put(pos, (byte)(text.charAt(x) & 0xFF));
                buffer.put(pos + 1, (byte)FixedWidthFontRenderer.getColour(textColour.charAt(x), Colour.WHITE));
                buffer.put(pos + 2, (byte)FixedWidthFontRenderer.getColour(background.charAt(x), Colour.BLACK));
                pos += 3;
            }
        }
        buffer.limit(pos);
    }

    public static void setUniformData(ByteBuffer buffer, Terminal terminal, boolean greyscale) {
        int pos = 0;
        Palette palette = terminal.getPalette();
        for (int i = 0; i < 16; ++i) {
            double[] colour = palette.getColour(i);
            if (greyscale) {
                float f = FixedWidthFontRenderer.toGreyscale(colour);
                buffer.putFloat(pos, f).putFloat(pos + 4, f).putFloat(pos + 8, f);
            } else {
                buffer.putFloat(pos, (float)colour[0]).putFloat(pos + 4, (float)colour[1]).putFloat(pos + 8, (float)colour[2]);
            }
            pos += 16;
        }
        boolean showCursor = FixedWidthFontRenderer.isCursorVisible(terminal);
        buffer.putInt(pos, terminal.getWidth()).putInt(pos + 4, terminal.getHeight()).putInt(pos + 8, showCursor ? terminal.getCursorX() : -2).putInt(pos + 12, showCursor ? terminal.getCursorY() : -2).putInt(pos + 16, 15 - terminal.getTextColour());
        buffer.limit(276);
    }
}

