/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.ComputerScreenBase;
import dan200.computercraft.client.gui.widgets.ComputerSidebar;
import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.inventory.ContainerViewComputer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public final class GuiComputer<T extends ContainerComputerBase>
extends ComputerScreenBase<T> {
    private final int termWidth;
    private final int termHeight;

    private GuiComputer(T container, PlayerInventory player, ITextComponent title, int termWidth, int termHeight) {
        super(container, player, title, 12);
        this.termWidth = termWidth;
        this.termHeight = termHeight;
        this.field_146999_f = WidgetTerminal.getWidth(termWidth) + 24 + 17;
        this.field_147000_g = WidgetTerminal.getHeight(termHeight) + 24;
    }

    public static GuiComputer<ContainerComputerBase> create(ContainerComputerBase container, PlayerInventory inventory, ITextComponent component) {
        return new GuiComputer<ContainerComputerBase>(container, inventory, component, ComputerCraft.computerTermWidth, ComputerCraft.computerTermHeight);
    }

    public static GuiComputer<ContainerComputerBase> createPocket(ContainerComputerBase container, PlayerInventory inventory, ITextComponent component) {
        return new GuiComputer<ContainerComputerBase>(container, inventory, component, ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight);
    }

    public static GuiComputer<ContainerViewComputer> createView(ContainerViewComputer container, PlayerInventory inventory, ITextComponent component) {
        return new GuiComputer<ContainerViewComputer>(container, inventory, component, container.getWidth(), container.getHeight());
    }

    @Override
    protected WidgetTerminal createTerminal() {
        return new WidgetTerminal(this.computer, this.field_147003_i + 17 + 12, this.field_147009_r + 12, this.termWidth, this.termHeight);
    }

    public void func_230450_a_(@Nonnull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        ComputerBorderRenderer.render(stack.func_227866_c_().func_227870_a_(), ComputerBorderRenderer.getTexture(this.family), this.terminal.field_230690_l_, this.terminal.field_230691_m_, this.func_230927_p_(), 0xF000F0, this.terminal.func_230998_h_(), this.terminal.func_238483_d_());
        ComputerSidebar.renderBackground(stack, this.field_147003_i, this.field_147009_r + this.sidebarYOffset);
    }
}

