/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle.event;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.event.TurtleAction;
import dan200.computercraft.api.turtle.event.TurtlePlayerEvent;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public abstract class TurtleBlockEvent
extends TurtlePlayerEvent {
    private final World world;
    private final BlockPos pos;

    protected TurtleBlockEvent(@Nonnull ITurtleAccess turtle, @Nonnull TurtleAction action, @Nonnull FakePlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
        super(turtle, action, player);
        Objects.requireNonNull(world, "world cannot be null");
        Objects.requireNonNull(pos, "pos cannot be null");
        this.world = world;
        this.pos = pos;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static class Inspect
    extends TurtleBlockEvent {
        private final BlockState state;
        private final Map<String, Object> data;

        public Inspect(@Nonnull ITurtleAccess turtle, @Nonnull FakePlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Map<String, Object> data) {
            super(turtle, TurtleAction.INSPECT, player, world, pos);
            Objects.requireNonNull(state, "state cannot be null");
            Objects.requireNonNull(data, "data cannot be null");
            this.data = data;
            this.state = state;
        }

        @Nonnull
        public BlockState getState() {
            return this.state;
        }

        @Nonnull
        public Map<String, Object> getData() {
            return this.data;
        }

        public void addData(@Nonnull Map<String, ?> newData) {
            Objects.requireNonNull(newData, "newData cannot be null");
            this.data.putAll(newData);
        }
    }

    public static class Place
    extends TurtleBlockEvent {
        private final ItemStack stack;

        public Place(@Nonnull ITurtleAccess turtle, @Nonnull FakePlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
            super(turtle, TurtleAction.PLACE, player, world, pos);
            Objects.requireNonNull(stack, "stack cannot be null");
            this.stack = stack;
        }

        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }
    }

    public static class Move
    extends TurtleBlockEvent {
        public Move(@Nonnull ITurtleAccess turtle, @Nonnull FakePlayer player, @Nonnull World world, @Nonnull BlockPos pos) {
            super(turtle, TurtleAction.MOVE, player, world, pos);
        }
    }

    public static class Dig
    extends TurtleBlockEvent {
        private final BlockState block;
        private final ITurtleUpgrade upgrade;
        private final TurtleSide side;

        public Dig(@Nonnull ITurtleAccess turtle, @Nonnull FakePlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState block, @Nonnull ITurtleUpgrade upgrade, @Nonnull TurtleSide side) {
            super(turtle, TurtleAction.DIG, player, world, pos);
            Objects.requireNonNull(block, "block cannot be null");
            Objects.requireNonNull(upgrade, "upgrade cannot be null");
            Objects.requireNonNull(side, "side cannot be null");
            this.block = block;
            this.upgrade = upgrade;
            this.side = side;
        }

        @Nonnull
        public BlockState getBlock() {
            return this.block;
        }

        @Nonnull
        public ITurtleUpgrade getUpgrade() {
            return this.upgrade;
        }

        @Nonnull
        public TurtleSide getSide() {
            return this.side;
        }
    }
}

