/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib.doubles;

import cc.tweaked.internal.cobalt.Buffer;
import cc.tweaked.internal.cobalt.lib.doubles.Assert;
import cc.tweaked.internal.cobalt.lib.doubles.BigNumDtoa;
import cc.tweaked.internal.cobalt.lib.doubles.DecimalRepBuf;
import cc.tweaked.internal.cobalt.lib.doubles.FastDtoa;
import cc.tweaked.internal.cobalt.lib.doubles.FixedDtoa;
import cc.tweaked.internal.cobalt.lib.doubles.Ieee;
import java.util.Objects;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class DoubleToStringConverter {
    public static final @UnknownVal @UnknownSignedness Symbols ECMA_SCRIPT_SYMBOLS = new Symbols("Infinity", "NaN", 101);
    public static final @UnknownVal @Signed int MAX_FIXED_DIGITS_BEFORE_POINT = 308;
    private static final @UnknownVal @Signed double FIRST_NON_FIXED = 1.0E308;
    public static final @UnknownVal @Signed int MAX_FIXED_DIGITS_AFTER_POINT = 100;
    public static final @UnknownVal @Signed int MAX_EXPONENTIAL_DIGITS = 120;
    public static final @UnknownVal @Signed int MIN_PRECISION_DIGITS = 1;
    public static final @UnknownVal @Signed int MAX_PRECISION_DIGITS = 120;
    public static final @UnknownVal @Signed int BASE_10_MAXIMAL_LENGTH = 17;
    public static final @UnknownVal @Signed int EXPONENTIAL_REP_CAPACITY = 122;
    public static final @UnknownVal @Signed int FIXED_REP_CAPACITY = 409;
    public static final @UnknownVal @Signed int PRECISION_REP_CAPACITY = 121;
    public static final @UnknownVal @Signed int MAX_EXPONENT_LENGTH = 5;
    private static final @UnknownVal @Signed int ASCII_ZERO = 48;
    private final @UnknownVal @Signed int flags;
    private final @UnknownVal @UnknownSignedness PrecisionPolicy precisionPolicy;
    private final @UnknownVal @Signed int minExponentWidth;

    public DoubleToStringConverter(@UnknownVal @Signed int flags, @UnknownVal @UnknownSignedness PrecisionPolicy precisionPolicy) {
        this(flags, precisionPolicy, 0);
    }

    public DoubleToStringConverter(@UnknownVal @Signed int flags, @UnknownVal @UnknownSignedness PrecisionPolicy precisionPolicy, @UnknownVal @Signed int minExponentWidth) {
        this.flags = flags;
        this.precisionPolicy = Objects.requireNonNull(precisionPolicy);
        this.minExponentWidth = minExponentWidth;
        if ((flags & 2) == 0 && (flags & 4) != 0) {
            throw new IllegalArgumentException("the flag EMIT_TRAILING_DECIMAL_POINT must be set when EMIT_TRAILING_ZERO_AFTER_POINT is set");
        }
    }

    public static @UnknownVal @UnknownSignedness DoubleToStringConverter ecmaScriptConverter() {
        int flags = 9;
        return new DoubleToStringConverter(flags, new PrecisionPolicy(6, 0));
    }

    private void handleSpecialValues(@UnknownVal @Signed double value, @UnknownVal @UnknownSignedness FormatOptions fo, @UnknownVal @UnknownSignedness Buffer resultBuilder) {
        String symbol;
        boolean isInfinite;
        boolean sign = value < 0.0;
        int effectiveWidth = fo.getWidth();
        if (sign || fo.isExplicitPlus() || fo.isSpaceWhenPositive()) {
            --effectiveWidth;
        }
        if (isInfinite = Double.isInfinite(value)) {
            symbol = fo.getSymbols().getInfinitySymbol();
        } else if (Double.isNaN(value)) {
            symbol = fo.getSymbols().getNanSymbol();
        } else {
            throw new IllegalStateException("Unreachable");
        }
        if (!fo.isLeftAdjust() && symbol.length() < effectiveWidth) {
            DoubleToStringConverter.addPadding(resultBuilder, 32, effectiveWidth - symbol.length());
        }
        if (sign) {
            resultBuilder.append('-');
        } else if (fo.isExplicitPlus()) {
            resultBuilder.append('+');
        } else if (fo.isSpaceWhenPositive()) {
            resultBuilder.append(' ');
        }
        resultBuilder.append(symbol);
        if (fo.isLeftAdjust() && symbol.length() < effectiveWidth) {
            DoubleToStringConverter.addPadding(resultBuilder, 32, effectiveWidth - symbol.length());
        }
    }

    private void createExponentialRepresentation(@UnknownVal @UnknownSignedness DecimalRepBuf decimalDigits, @UnknownVal @Signed double value, @UnknownVal @Signed int length, @UnknownVal @Signed int exponent, @UnknownVal @UnknownSignedness FormatOptions fo, @UnknownVal @UnknownSignedness Buffer resultBuilder) {
        Assert.requireArg(decimalDigits.length() != 0, "decimalDigits must not be empty");
        Assert.requireArg(length <= decimalDigits.length(), "length must be smaller than decimalDigits");
        if (Assert.assertEnabled()) {
            Assert.assertThat((double)exponent < 10000.0);
        }
        ExponentPart exponentPart = this.createExponentPart(exponent);
        boolean emitTrailingPoint = fo.isAlternateForm() || (this.flags & 2) != 0;
        boolean emitTrailingZero = (this.flags & 4) != 0;
        int padWidth = 0;
        if (fo.getWidth() > 0) {
            int valueWidth = this.calculateExpWidth(length, fo, exponentPart, this.shouldEmitMinus(value), emitTrailingPoint, emitTrailingZero);
            padWidth = fo.getWidth() - valueWidth;
        }
        if (padWidth > 0 && !fo.isLeftAdjust() && !fo.isZeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, 32, padWidth);
        }
        this.appendSign(value, fo, resultBuilder);
        if (padWidth > 0 && !fo.isLeftAdjust() && fo.isZeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, 48, padWidth);
        }
        resultBuilder.append(decimalDigits.charAt(0));
        if (length != 1) {
            resultBuilder.append('.');
            resultBuilder.append(decimalDigits.getBuffer(), 1, length - 1);
        } else if (fo.isAlternateForm()) {
            resultBuilder.append('.');
        }
        resultBuilder.append((char)fo.getSymbols().getExponentCharacter());
        resultBuilder.append(exponentPart.getBuffer(), exponentPart.getStart(), exponentPart.length());
        if (padWidth > 0 && fo.isLeftAdjust()) {
            DoubleToStringConverter.addPadding(resultBuilder, 32, padWidth);
        }
    }

    private @UnknownVal @UnknownSignedness ExponentPart createExponentPart(@UnknownVal @Signed int exponent) {
        boolean sign = false;
        if (exponent < 0) {
            sign = true;
            exponent = -exponent;
        }
        char[] buffer = new char[6];
        int firstCharPos = 6;
        if (exponent == 0) {
            buffer[--firstCharPos] = 48;
        } else {
            while (exponent > 0) {
                buffer[--firstCharPos] = (char)(48 + exponent % 10);
                exponent /= 10;
            }
        }
        while (6 - firstCharPos < Math.min(this.minExponentWidth, 5)) {
            buffer[--firstCharPos] = 48;
        }
        if (sign) {
            buffer[--firstCharPos] = 45;
        } else if ((this.flags & 1) != 0) {
            buffer[--firstCharPos] = 43;
        }
        return new ExponentPart(buffer, firstCharPos, 6 - firstCharPos);
    }

    private void createDecimalRepresentation(@UnknownVal @UnknownSignedness DecimalRepBuf decimalDigits, @UnknownVal @Signed double value, @UnknownVal @Signed int digitsAfterPoint, @UnknownVal @UnknownSignedness FormatOptions fo, @UnknownVal @UnknownSignedness Buffer resultBuilder) {
        int remainingDigits;
        int decimalPoint = decimalDigits.getPointPosition();
        int digitsLength = decimalDigits.length();
        if (digitsLength > decimalPoint + digitsAfterPoint) {
            throw new IllegalArgumentException("too many digits for given digitAfterPoint");
        }
        boolean emitTrailingPoint = fo.isAlternateForm() || (this.flags & 2) != 0;
        boolean emitTrailingZero = (this.flags & 4) != 0;
        int padWidth = 0;
        if (fo.getWidth() > 0) {
            int valueWidth = this.calculateDecimalWidth(decimalDigits, fo, digitsAfterPoint, this.shouldEmitMinus(value), emitTrailingPoint, emitTrailingZero);
            padWidth = fo.getWidth() - valueWidth;
        }
        if (padWidth > 0 && !fo.isLeftAdjust() && !fo.isZeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, 32, padWidth);
        }
        this.appendSign(value, fo, resultBuilder);
        if (padWidth > 0 && !fo.isLeftAdjust() && fo.isZeroPad()) {
            DoubleToStringConverter.addPadding(resultBuilder, 48, padWidth);
        }
        if (decimalPoint <= 0) {
            resultBuilder.append('0');
            if (digitsAfterPoint > 0) {
                resultBuilder.append('.');
                DoubleToStringConverter.addPadding(resultBuilder, 48, -decimalPoint);
                if (Assert.assertEnabled()) {
                    Assert.assertThat(digitsLength <= digitsAfterPoint - -decimalPoint);
                }
                resultBuilder.append(decimalDigits.getBuffer(), 0, decimalDigits.length());
                remainingDigits = digitsAfterPoint - -decimalPoint - digitsLength;
                DoubleToStringConverter.addPadding(resultBuilder, 48, remainingDigits);
            }
        } else if (decimalPoint >= digitsLength) {
            resultBuilder.append(decimalDigits.getBuffer(), 0, decimalDigits.length());
            DoubleToStringConverter.addPadding(resultBuilder, 48, decimalPoint - digitsLength);
            if (digitsAfterPoint > 0) {
                resultBuilder.append('.');
                DoubleToStringConverter.addPadding(resultBuilder, 48, digitsAfterPoint);
            }
        } else {
            if (Assert.assertEnabled()) {
                Assert.assertThat(digitsAfterPoint > 0);
            }
            resultBuilder.append(decimalDigits.getBuffer(), 0, decimalPoint);
            resultBuilder.append('.');
            if (Assert.assertEnabled()) {
                Assert.assertThat(digitsLength - decimalPoint <= digitsAfterPoint);
            }
            resultBuilder.append(decimalDigits.getBuffer(), decimalPoint, digitsLength - decimalPoint);
            remainingDigits = digitsAfterPoint - (digitsLength - decimalPoint);
            DoubleToStringConverter.addPadding(resultBuilder, 48, remainingDigits);
        }
        if (digitsAfterPoint == 0 && emitTrailingPoint) {
            resultBuilder.append('.');
            if (emitTrailingZero) {
                resultBuilder.append('0');
            }
        }
        if (padWidth > 0 && fo.isLeftAdjust()) {
            DoubleToStringConverter.addPadding(resultBuilder, fo.isZeroPad() ? 48 : 32, padWidth);
        }
    }

    private @UnknownVal @Signed int calculateDecimalWidth(@UnknownVal @UnknownSignedness DecimalRepBuf decimalDigits, @UnknownVal @UnknownSignedness FormatOptions fo, @UnknownVal @Signed int digitsAfterPoint, @UnknownVal @UnknownSignedness boolean emitMinus, @UnknownVal @UnknownSignedness boolean emitTrailingPoint, @UnknownVal @UnknownSignedness boolean emitTrailingZero) {
        int decimalPoint = decimalDigits.getPointPosition();
        int digitsLength = decimalDigits.length();
        int valueWidth = digitsLength == 0 ? 1 + (digitsAfterPoint > 0 ? 1 + digitsAfterPoint : 0) : (decimalPoint <= 0 ? 2 + digitsAfterPoint : (digitsLength > 0 ? decimalPoint + (digitsAfterPoint > 0 ? 1 + digitsAfterPoint : 0) : 1 + (digitsAfterPoint > 0 ? 1 + digitsAfterPoint : 0)));
        if (digitsAfterPoint == 0 && emitTrailingPoint) {
            valueWidth += emitTrailingZero ? 2 : 1;
        }
        if (emitMinus || fo.isExplicitPlus() || fo.isSpaceWhenPositive()) {
            ++valueWidth;
        }
        return valueWidth;
    }

    private @UnknownVal @Signed int calculateExpWidth(@UnknownVal @Signed int digitsLength, @UnknownVal @UnknownSignedness FormatOptions fo, @UnknownVal @UnknownSignedness ExponentPart exponentPart, @UnknownVal @UnknownSignedness boolean emitMinus, @UnknownVal @UnknownSignedness boolean emitTrailingPoint, @UnknownVal @UnknownSignedness boolean emitTrailingZero) {
        int valueWidth = digitsLength + exponentPart.length() + (digitsLength > 1 ? 2 : 1);
        if (emitMinus || fo.isExplicitPlus() || fo.isSpaceWhenPositive()) {
            ++valueWidth;
        }
        if (digitsLength == 1 && emitTrailingPoint) {
            valueWidth += emitTrailingZero ? 2 : 1;
        }
        return valueWidth;
    }

    public void toFixed(@UnknownVal @Signed double value, @UnknownVal @Signed int requestedDigits, @UnknownVal @UnknownSignedness FormatOptions formatOptions, @UnknownVal @UnknownSignedness Buffer resultBuilder) {
        if (new Ieee.Double(value).isSpecial()) {
            this.handleSpecialValues(value, formatOptions, resultBuilder);
            return;
        }
        if (requestedDigits > 100) {
            throw new IllegalArgumentException("requestedDigits too large. max: 308(MAX_FIXED_DIGITS_BEFORE_POINT) got: " + requestedDigits);
        }
        if (value > 1.0E308 || value < -1.0E308) {
            throw new IllegalArgumentException("value >= 10^308(10^MAX_FIXED_DIGITS_BEFORE_POINT) got: " + value);
        }
        DecimalRepBuf decimalRep = new DecimalRepBuf(409);
        DoubleToStringConverter.doubleToAscii(value, DtoaMode.FIXED, requestedDigits, decimalRep);
        this.createDecimalRepresentation(decimalRep, value, requestedDigits, formatOptions, resultBuilder);
    }

    public void toExponential(@UnknownVal @Signed double value, @UnknownVal @Signed int requestedDigits, @UnknownVal @UnknownSignedness FormatOptions formatOptions, @UnknownVal @UnknownSignedness Buffer resultBuilder) {
        if (new Ieee.Double(value).isSpecial()) {
            this.handleSpecialValues(value, formatOptions, resultBuilder);
            return;
        }
        if (requestedDigits < 0) {
            throw new IllegalArgumentException(String.format("requestedDigits must be >= 0. got: %d", requestedDigits));
        }
        if (requestedDigits > 120) {
            throw new IllegalArgumentException(String.format("requestedDigits must be less than %d. got: %d", 120, requestedDigits));
        }
        DecimalRepBuf decimalRep = new DecimalRepBuf(122);
        DoubleToStringConverter.doubleToAscii(value, DtoaMode.PRECISION, requestedDigits + 1, decimalRep);
        if (Assert.assertEnabled()) {
            Assert.assertThat(decimalRep.length() <= requestedDigits + 1);
        }
        decimalRep.zeroExtend(requestedDigits + 1);
        int exponent = decimalRep.getPointPosition() - 1;
        this.createExponentialRepresentation(decimalRep, value, decimalRep.length(), exponent, formatOptions, resultBuilder);
    }

    public void toPrecision(@UnknownVal @Signed double value, @UnknownVal @Signed int precision, @UnknownVal @UnknownSignedness FormatOptions formatOptions, @UnknownVal @UnknownSignedness Buffer resultBuilder) {
        boolean asExponential;
        if (new Ieee.Double(value).isSpecial()) {
            this.handleSpecialValues(value, formatOptions, resultBuilder);
            return;
        }
        if (precision < 1 || precision > 120) {
            throw new IllegalArgumentException(String.format("argument precision must be in range (%d,%d)", 1, 120));
        }
        DecimalRepBuf decimalRep = new DecimalRepBuf(121);
        DoubleToStringConverter.doubleToAscii(value, DtoaMode.PRECISION, precision, decimalRep);
        if (Assert.assertEnabled()) {
            Assert.assertThat(decimalRep.length() <= precision);
        }
        int decimalPoint = decimalRep.getPointPosition();
        int exponent = decimalPoint - 1;
        int extraZero = (this.flags & 4) != 0 ? 1 : 0;
        boolean bl = asExponential = -decimalPoint + 1 > this.precisionPolicy.getMaxLeadingZeroes() || decimalPoint - precision + extraZero > this.precisionPolicy.getMaxTrailingZeroes();
        if ((this.flags & 0x10) != 0 && !formatOptions.isAlternateForm()) {
            decimalRep.truncateZeros(asExponential);
            precision = Math.min(precision, decimalRep.length());
        }
        if (asExponential) {
            decimalRep.zeroExtend(precision);
            this.createExponentialRepresentation(decimalRep, value, precision, exponent, formatOptions, resultBuilder);
        } else {
            this.createDecimalRepresentation(decimalRep, value, Math.max(0, precision - decimalRep.getPointPosition()), formatOptions, resultBuilder);
        }
    }

    private @UnknownVal @UnknownSignedness boolean shouldEmitMinus(@UnknownVal @Signed double value) {
        boolean uniqueZero = (this.flags & 8) != 0;
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L && (value != 0.0 || !uniqueZero);
    }

    private void appendSign(@UnknownVal @Signed double value, @UnknownVal @UnknownSignedness FormatOptions formatOptions, @UnknownVal @UnknownSignedness Buffer resultBuilder) {
        if (this.shouldEmitMinus(value)) {
            resultBuilder.append('-');
        } else if (formatOptions.isSpaceWhenPositive()) {
            resultBuilder.append(' ');
        } else if (formatOptions.isExplicitPlus()) {
            resultBuilder.append('+');
        }
    }

    private static @UnknownVal @UnknownSignedness BigNumDtoa.BignumDtoaMode dtoaToBignumDtoaMode(@UnknownVal @UnknownSignedness DtoaMode dtoaMode) {
        switch (dtoaMode) {
            case FIXED: {
                return BigNumDtoa.BignumDtoaMode.FIXED;
            }
            case PRECISION: {
                return BigNumDtoa.BignumDtoaMode.PRECISION;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    public static void doubleToAscii(@UnknownVal @Signed double v, @UnknownVal @UnknownSignedness DtoaMode mode, @UnknownVal @Signed int requestedDigits, @UnknownVal @UnknownSignedness DecimalRepBuf buffer) {
        boolean fastWorked;
        if (Assert.assertEnabled()) {
            Assert.requireArg(!new Ieee.Double(v).isSpecial(), "value can't be a special value");
        }
        Assert.requireArg(requestedDigits >= 0, "requestedDigits must be >= 0");
        buffer.reset();
        if (new Ieee.Double(v).sign() < 0) {
            buffer.setSign(true);
            v = -v;
        } else {
            buffer.setSign(false);
        }
        if (mode == DtoaMode.PRECISION && requestedDigits == 0) {
            return;
        }
        if (v == 0.0) {
            buffer.append(0);
            buffer.setPointPosition(1);
            return;
        }
        switch (mode) {
            case FIXED: {
                fastWorked = FixedDtoa.fastFixedDtoa(v, requestedDigits, buffer);
                break;
            }
            case PRECISION: {
                fastWorked = FastDtoa.fastDtoa(v, requestedDigits, buffer);
                break;
            }
            default: {
                throw new IllegalStateException("Unreachable");
            }
        }
        if (fastWorked) {
            return;
        }
        buffer.reset();
        BigNumDtoa.BignumDtoaMode dtoaMode = DoubleToStringConverter.dtoaToBignumDtoaMode(mode);
        BigNumDtoa.bignumDtoa(v, dtoaMode, requestedDigits, buffer);
    }

    private static void addPadding(@UnknownVal @UnknownSignedness Buffer sb, @Unsigned @UnknownVal int character, @UnknownVal @Signed int count) {
        for (int i = count; i > 0; --i) {
            sb.append((char)character);
        }
    }

    private static class ExponentPart {
        private final @UnknownVal @Unsigned char @UnknownVal @UnknownSignedness [] buffer;
        private final @UnknownVal @Signed int start;
        private final @UnknownVal @Signed int length;

        public ExponentPart(@UnknownVal @Unsigned char @UnknownVal @UnknownSignedness [] buffer, @UnknownVal @Signed int start, @UnknownVal @Signed int length) {
            this.buffer = buffer;
            this.start = start;
            this.length = length;
        }

        public @UnknownVal @Unsigned char @UnknownVal @UnknownSignedness [] getBuffer() {
            return this.buffer;
        }

        public @UnknownVal @Signed int getStart() {
            return this.start;
        }

        public @UnknownVal @Signed int length() {
            return this.length;
        }

        @SideEffectFree
        public @UnknownVal @UnknownSignedness String toString() {
            return String.valueOf(this.buffer, this.start, this.length);
        }
    }

    public static class FormatOptions {
        private final @UnknownVal @UnknownSignedness Symbols symbols;
        private final @UnknownVal @UnknownSignedness boolean explicitPlus;
        private final @UnknownVal @UnknownSignedness boolean spaceWhenPositive;
        private final @UnknownVal @UnknownSignedness boolean alternateForm;
        private final @UnknownVal @Signed int width;
        private final @UnknownVal @UnknownSignedness boolean zeroPad;
        private final @UnknownVal @UnknownSignedness boolean leftAdjust;

        public FormatOptions(@UnknownVal @UnknownSignedness Symbols symbols, @UnknownVal @UnknownSignedness boolean explicitPlus, @UnknownVal @UnknownSignedness boolean spaceWhenPositive, @UnknownVal @UnknownSignedness boolean alternateForm, @UnknownVal @Signed int width, @UnknownVal @UnknownSignedness boolean zeroPad, @UnknownVal @UnknownSignedness boolean leftAdjust) {
            this.symbols = symbols;
            this.explicitPlus = explicitPlus;
            this.spaceWhenPositive = spaceWhenPositive;
            this.alternateForm = alternateForm;
            this.width = width;
            this.zeroPad = zeroPad;
            this.leftAdjust = leftAdjust;
        }

        public @UnknownVal @UnknownSignedness Symbols getSymbols() {
            return this.symbols;
        }

        public @UnknownVal @UnknownSignedness boolean isExplicitPlus() {
            return this.explicitPlus;
        }

        public @UnknownVal @UnknownSignedness boolean isSpaceWhenPositive() {
            return this.spaceWhenPositive;
        }

        public @UnknownVal @UnknownSignedness boolean isAlternateForm() {
            return this.alternateForm;
        }

        public @UnknownVal @Signed int getWidth() {
            return this.width;
        }

        public @UnknownVal @UnknownSignedness boolean isZeroPad() {
            return this.zeroPad;
        }

        public @UnknownVal @UnknownSignedness boolean isLeftAdjust() {
            return this.leftAdjust;
        }
    }

    public static class PrecisionPolicy {
        private final @UnknownVal @Signed int maxLeadingZeroes;
        private final @UnknownVal @Signed int maxTrailingZeroes;

        public PrecisionPolicy(@UnknownVal @Signed int maxLeadingZeroes, @UnknownVal @Signed int maxTrailingZeroes) {
            this.maxLeadingZeroes = maxLeadingZeroes;
            this.maxTrailingZeroes = maxTrailingZeroes;
        }

        public @UnknownVal @Signed int getMaxLeadingZeroes() {
            return this.maxLeadingZeroes;
        }

        public @UnknownVal @Signed int getMaxTrailingZeroes() {
            return this.maxTrailingZeroes;
        }
    }

    public static class Symbols {
        private final @UnknownVal @UnknownSignedness String infinitySymbol;
        private final @UnknownVal @UnknownSignedness String nanSymbol;
        private final @Unsigned @UnknownVal int exponentCharacter;

        public Symbols(@UnknownVal @UnknownSignedness String infinitySymbol, @UnknownVal @UnknownSignedness String nanSymbol, @Unsigned @UnknownVal int exponentCharacter) {
            this.infinitySymbol = Objects.requireNonNull(infinitySymbol);
            this.nanSymbol = Objects.requireNonNull(nanSymbol);
            this.exponentCharacter = exponentCharacter;
        }

        public @UnknownVal @UnknownSignedness String getInfinitySymbol() {
            return this.infinitySymbol;
        }

        public @UnknownVal @UnknownSignedness String getNanSymbol() {
            return this.nanSymbol;
        }

        public @Unsigned @UnknownVal int getExponentCharacter() {
            return this.exponentCharacter;
        }
    }

    public static enum DtoaMode {
        FIXED,
        PRECISION;

    }

    public static class Flags {
        public static final @UnknownVal @Signed int NO_FLAGS = 0;
        public static final @UnknownVal @Signed int EMIT_POSITIVE_EXPONENT_SIGN = 1;
        public static final @UnknownVal @Signed int EMIT_TRAILING_DECIMAL_POINT = 2;
        public static final @UnknownVal @Signed int EMIT_TRAILING_ZERO_AFTER_POINT = 4;
        public static final @UnknownVal @Signed int UNIQUE_ZERO = 8;
        public static final @UnknownVal @Signed int NO_TRAILING_ZERO = 16;
    }
}

