/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.compiler;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.LuaInteger;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.compiler.CompileException;
import cc.tweaked.internal.cobalt.function.LocalVariable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BytecodeLoader {
    public static final int NUMBER_FORMAT_FLOATS_OR_DOUBLES = 0;
    public static final int NUMBER_FORMAT_INTS_ONLY = 1;
    public static final int NUMBER_FORMAT_NUM_PATCH_INT32 = 4;
    public static final int LUAC_VERSION = 81;
    public static final int LUAC_FORMAT = 0;
    public static final int LUAC_HEADERSIZE = 12;
    private boolean luacLittleEndian;
    private int luacSizeofSizeT;
    private int luacNumberFormat;
    public final DataInputStream is;
    private static final LuaValue[] NOVALUES = new LuaValue[0];
    private static final Prototype[] NOPROTOS = new Prototype[0];
    private static final LocalVariable[] NOLOCVARS = new LocalVariable[0];
    private static final LuaString[] NOSTRVALUES = new LuaString[0];
    private static final int[] NOINTS = new int[0];
    private byte[] buf = new byte[512];

    public BytecodeLoader(InputStream stream) {
        this.is = new DataInputStream(stream);
    }

    private int loadInt() throws IOException {
        this.is.readFully(this.buf, 0, 4);
        return this.luacLittleEndian ? this.buf[3] << 24 | (0xFF & this.buf[2]) << 16 | (0xFF & this.buf[1]) << 8 | 0xFF & this.buf[0] : this.buf[0] << 24 | (0xFF & this.buf[1]) << 16 | (0xFF & this.buf[2]) << 8 | 0xFF & this.buf[3];
    }

    private int[] loadIntArray() throws IOException {
        int n = this.loadInt();
        if (n == 0) {
            return NOINTS;
        }
        int m = n << 2;
        if (this.buf.length < m) {
            this.buf = new byte[m];
        }
        this.is.readFully(this.buf, 0, m);
        int[] array = new int[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            array[i] = this.luacLittleEndian ? this.buf[j + 3] << 24 | (0xFF & this.buf[j + 2]) << 16 | (0xFF & this.buf[j + 1]) << 8 | 0xFF & this.buf[j + 0] : this.buf[j + 0] << 24 | (0xFF & this.buf[j + 1]) << 16 | (0xFF & this.buf[j + 2]) << 8 | 0xFF & this.buf[j + 3];
            ++i;
            j += 4;
        }
        return array;
    }

    private long loadInt64() throws IOException {
        int b;
        int a;
        if (this.luacLittleEndian) {
            a = this.loadInt();
            b = this.loadInt();
        } else {
            b = this.loadInt();
            a = this.loadInt();
        }
        return (long)b << 32 | (long)a & 0xFFFFFFFFL;
    }

    private LuaString loadString() throws IOException {
        int size;
        int n = size = this.luacSizeofSizeT == 8 ? (int)this.loadInt64() : this.loadInt();
        if (size == 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        this.is.readFully(bytes, 0, size);
        return LuaString.valueOf(bytes, 0, bytes.length - 1);
    }

    public static LuaValue longBitsToLuaNumber(long bits) {
        int shift;
        long intPrecMask;
        long f;
        if ((bits & Long.MAX_VALUE) == 0L) {
            return Constants.ZERO;
        }
        int e = (int)(bits >> 52 & 0x7FFL) - 1023;
        if (e >= 0 && e < 31 && ((f = bits & 0xFFFFFFFFFFFFFL) & (intPrecMask = (1L << (shift = 52 - e)) - 1L)) == 0L) {
            int intValue = (int)(f >> shift) | 1 << e;
            return LuaInteger.valueOf(bits >> 63 != 0L ? -intValue : intValue);
        }
        return ValueFactory.valueOf(Double.longBitsToDouble(bits));
    }

    private LuaValue loadNumber() throws IOException {
        if (this.luacNumberFormat == 1) {
            return LuaInteger.valueOf(this.loadInt());
        }
        return BytecodeLoader.longBitsToLuaNumber(this.loadInt64());
    }

    private void loadConstants(Prototype f) throws IOException {
        int n = this.loadInt();
        LuaValue[] values = n > 0 ? new LuaValue[n] : NOVALUES;
        block7: for (int i = 0; i < n; ++i) {
            switch (this.is.readByte()) {
                case 0: {
                    values[i] = Constants.NIL;
                    continue block7;
                }
                case 1: {
                    values[i] = 0 != this.is.readUnsignedByte() ? Constants.TRUE : Constants.FALSE;
                    continue block7;
                }
                case -2: {
                    values[i] = LuaInteger.valueOf(this.loadInt());
                    continue block7;
                }
                case 3: {
                    values[i] = this.loadNumber();
                    continue block7;
                }
                case 4: {
                    values[i] = this.loadString();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("bad constant");
                }
            }
        }
        f.k = values;
        n = this.loadInt();
        Prototype[] protos = n > 0 ? new Prototype[n] : NOPROTOS;
        for (int i = 0; i < n; ++i) {
            protos[i] = this.loadFunction(f.source);
        }
        f.p = protos;
    }

    private void loadDebug(Prototype f) throws IOException {
        int i;
        f.lineinfo = this.loadIntArray();
        int n = this.loadInt();
        f.locvars = n > 0 ? new LocalVariable[n] : NOLOCVARS;
        for (i = 0; i < n; ++i) {
            LuaString varname = this.loadString();
            int startpc = this.loadInt();
            int endpc = this.loadInt();
            f.locvars[i] = new LocalVariable(varname, startpc, endpc);
        }
        n = this.loadInt();
        f.upvalues = n > 0 ? new LuaString[n] : NOSTRVALUES;
        for (i = 0; i < n; ++i) {
            f.upvalues[i] = this.loadString();
        }
    }

    public Prototype loadFunction(LuaString p) throws IOException {
        Prototype f = new Prototype();
        f.source = this.loadString();
        if (f.source == null) {
            f.source = p;
        }
        f.linedefined = this.loadInt();
        f.lastlinedefined = this.loadInt();
        f.nups = this.is.readUnsignedByte();
        f.numparams = this.is.readUnsignedByte();
        f.is_vararg = this.is.readUnsignedByte();
        f.maxstacksize = this.is.readUnsignedByte();
        f.code = this.loadIntArray();
        this.loadConstants(f);
        this.loadDebug(f);
        return f;
    }

    public void loadHeader() throws IOException, CompileException {
        byte luacVersion = this.is.readByte();
        if (luacVersion != 81) {
            throw new CompileException("unsupported luac version");
        }
        byte luacFormat = this.is.readByte();
        this.luacLittleEndian = 0 != this.is.readByte();
        byte luacSizeofInt = this.is.readByte();
        this.luacSizeofSizeT = this.is.readByte();
        byte luacSizeofInstruction = this.is.readByte();
        byte luacSizeofLuaNumber = this.is.readByte();
        this.luacNumberFormat = this.is.readByte();
        switch (this.luacNumberFormat) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new CompileException("unsupported int size");
            }
        }
    }
}

