/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.explosion;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.utils.explosion.ExplosionHelper;
import com.buuz135.industrial.utils.explosion.ShortPos;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.IFluidBlock;

public class ProcessExplosion {
    public static DamageSource fusionExplosion = new DamageSource("damage.if.nuke").func_94540_d().func_76348_h().func_76361_j();
    public final Vector3f origin;
    private final ServerWorld world;
    private final MinecraftServer server;
    private final int minimumDelay;
    public double[] angularResistance;
    public boolean isDead = false;
    public int radius = 0;
    public int maxRadius;
    public double circumference = 0.0;
    public double meanResistance = 0.0;
    public boolean lava = true;
    public HashSet<Integer> blocksToUpdate = new HashSet();
    public LinkedList<HashSet<Integer>> destroyedBlocks = new LinkedList();
    public HashSet<Integer> lavaPositions = new HashSet();
    public HashSet<Integer> destroyedCache = new HashSet();
    public HashSet<Integer> scannedCache = new HashSet();
    public ShortPos shortPos;
    public Consumer<Double> progressMon = null;
    protected boolean calculationComplete = false;
    protected boolean detonated = false;
    protected long startTime = -1L;
    protected long calcWait = 0L;
    private BlockState lavaState;

    public ProcessExplosion(BlockPos origin, int radius, ServerWorld world, int minimumDelayTime, String owner) {
        this.origin = new Vector3f((float)origin.func_177958_n(), (float)origin.func_177956_o(), (float)origin.func_177952_p());
        this.shortPos = new ShortPos(origin);
        this.world = world;
        this.server = world.func_73046_m();
        this.minimumDelay = minimumDelayTime;
        this.angularResistance = new double[121];
        Arrays.fill(this.angularResistance, 100.0);
        IndustrialForegoing.LOGGER.info("Explosion Calculation Started for " + radius + " Block radius detonation! by " + owner);
        this.maxRadius = radius;
        this.lavaState = Blocks.field_150353_l.func_176223_P();
    }

    public void updateProcess() {
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.calcWait > 0L) {
            --this.calcWait;
            return;
        }
        if (!this.calculationComplete) {
            long t = System.currentTimeMillis();
            this.updateCalculation();
            t = System.currentTimeMillis() - t;
            this.calcWait = t / 40L;
            IndustrialForegoing.LOGGER.debug("Calculation Progress: " + MathHelper.func_76128_c((double)((double)this.radius / (double)this.maxRadius * 100.0)) + "% " + Runtime.getRuntime().freeMemory() / 1000000L);
            if (this.calcWait > 0L) {
                IndustrialForegoing.LOGGER.debug("Explosion Calc loop took " + t + "ms! Waiting " + this.calcWait + " ticks before continuing");
            }
            if (this.progressMon != null) {
                this.progressMon.accept((double)this.radius / (double)this.maxRadius);
            }
        } else if (this.minimumDelay == -1) {
            this.isDead = true;
        } else if ((System.currentTimeMillis() - this.startTime) / 1000L >= (long)this.minimumDelay) {
            this.detonate();
        }
    }

    public void updateCalculation() {
        BlockPos originPos = new BlockPos((double)this.origin.func_195899_a(), (double)this.origin.func_195900_b(), (double)this.origin.func_195902_c());
        double maxCoreHeight = 20.0 * ((double)this.maxRadius / 150.0);
        Vector3f posVecUp = new Vector3f();
        Vector3f posVecDown = new Vector3f();
        SimplexNoiseGenerator noise = new SimplexNoiseGenerator(this.world.func_201674_k());
        for (int x = originPos.func_177958_n() - this.radius; x < originPos.func_177958_n() + this.radius; ++x) {
            for (int z = originPos.func_177952_p() - this.radius; z < originPos.func_177952_p() + this.radius; ++z) {
                double dist = this.calculateDistanceBetweenPoints(x, z, originPos.func_177958_n(), originPos.func_177952_p());
                if (!(dist < (double)this.radius) || !(dist >= (double)(this.radius - 1))) continue;
                posVecUp.func_195905_a((float)x, this.origin.func_195900_b(), (float)z);
                double radialAngle = this.getRadialAngle(posVecUp);
                double radialResistance = this.getRadialResistance(radialAngle);
                double angularLoad = this.meanResistance / radialResistance * 1.0;
                double radialPos = 1.0 - (double)this.radius / (double)this.maxRadius;
                double coreFalloff = Math.max(0.0, (radialPos - 0.8) * 5.0);
                coreFalloff = 1.0 - (1.0 - coreFalloff) * (1.0 - coreFalloff) * (1.0 - coreFalloff);
                double coreHeight = coreFalloff * maxCoreHeight;
                double edgeNoise = Math.max(0.0, (-radialPos + 0.2) * 5.0);
                double edgeScatter = edgeNoise * (double)this.world.func_201674_k().nextInt(10);
                double sim = noise.func_151605_a((double)x / 50.0, (double)z / 50.0);
                edgeNoise = 1.0 + Math.abs(sim) * edgeNoise * 8.0;
                double power = 10000.0 * radialPos * radialPos * radialPos * angularLoad * edgeNoise + edgeScatter;
                double heightUp = 20.0 + (5.0 + (double)this.radius / 10.0) * angularLoad;
                double heightDown = coreHeight + (5.0 + (double)this.radius / 10.0) * angularLoad * (1.0 - coreFalloff);
                posVecDown.func_195905_a(posVecUp.func_195899_a(), posVecUp.func_195900_b(), posVecUp.func_195902_c());
                double resist = this.trace(posVecUp, power * (1.0 + 8.0 * radialPos), (int)(heightUp += Math.abs(sim) * 4.0 + this.world.func_201674_k().nextDouble()) * 3, 1, 0.0, 0);
                posVecDown.func_195905_a(posVecDown.func_195899_a(), posVecDown.func_195900_b() - 1.0f, posVecDown.func_195902_c());
                resist += this.trace(posVecDown, power, (int)(heightDown += Math.abs(sim) * 4.0 + this.world.func_201674_k().nextDouble()), -1, 0.0, 0);
                resist *= 1.0 / angularLoad;
                if (!(radialPos < 0.8)) continue;
                this.addRadialResistance(radialAngle, resist);
            }
        }
        this.recalcResist();
        ++this.radius;
        this.circumference = Math.PI * 2 * (double)this.radius;
        this.destroyedBlocks.add(this.destroyedCache);
        this.destroyedCache = new HashSet();
        this.scannedCache = new HashSet();
        if (this.radius >= this.maxRadius) {
            IndustrialForegoing.LOGGER.info("Explosion Calculation Completed in " + (System.currentTimeMillis() - this.startTime) / 1000L + "s");
            this.calculationComplete = true;
        }
    }

    public double calculateDistanceBetweenPoints(double x1, double y1, double x2, double y2) {
        return Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
    }

    private void recalcResist() {
        double total = 0.0;
        for (double resist : this.angularResistance) {
            total += resist;
        }
        this.meanResistance = total / (double)this.angularResistance.length;
    }

    public double getRadialAngle(Vector3f pos) {
        double theta = Math.atan2(pos.func_195899_a() - this.origin.func_195899_a(), this.origin.func_195902_c() - pos.func_195902_c());
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        return theta / (Math.PI * 2) * (double)this.angularResistance.length;
    }

    public double getRadialResistance(double radialPos) {
        int max;
        int min = MathHelper.func_76128_c((double)radialPos);
        if (min >= this.angularResistance.length) {
            min -= this.angularResistance.length;
        }
        if ((max = MathHelper.func_76143_f((double)radialPos)) >= this.angularResistance.length) {
            max -= this.angularResistance.length;
        }
        double delta = radialPos - (double)min;
        return this.angularResistance[min] * (1.0 - delta) + this.angularResistance[max] * delta;
    }

    public void addRadialResistance(double radialPos, double power) {
        int max;
        int min = MathHelper.func_76128_c((double)radialPos);
        if (min >= this.angularResistance.length) {
            min -= this.angularResistance.length;
        }
        if ((max = MathHelper.func_76143_f((double)radialPos)) >= this.angularResistance.length) {
            max -= this.angularResistance.length;
        }
        double delta = radialPos - (double)min;
        int n = min;
        this.angularResistance[n] = this.angularResistance[n] + power * (1.0 - delta);
        int n2 = max;
        this.angularResistance[n2] = this.angularResistance[n2] + power * delta;
    }

    private double trace(Vector3f posVec, double power, int dist, int traceDir, double totalResist, int travel) {
        if (dist > 100) {
            dist = 100;
        }
        if (dist <= 0 || power <= 0.0 || posVec.func_195900_b() < 0.0f || posVec.func_195900_b() > 255.0f) {
            return totalResist;
        }
        --dist;
        ++travel;
        Integer iPos = this.shortPos.getIntPos(posVec);
        if (this.scannedCache.contains(iPos) || this.destroyedCache.contains(iPos)) {
            posVec.func_195905_a(posVec.func_195899_a(), posVec.func_195900_b() + (float)traceDir, posVec.func_195902_c());
            return this.trace(posVec, power, dist, traceDir, totalResist, travel);
        }
        BlockPos pos = new BlockPos((double)posVec.func_195899_a(), (double)posVec.func_195900_b(), (double)posVec.func_195902_c());
        double r = 1.0;
        BlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockReader)this.world, pos)) {
            Material mat = state.func_185904_a();
            double effectivePower = power / 10.0 * ((double)dist / (double)(dist + travel));
            r = block.func_149638_a();
            if (effectivePower >= r) {
                this.destroyedCache.add(iPos);
            } else if (mat == Material.field_151586_h || mat == Material.field_151587_i) {
                if (effectivePower > 5.0) {
                    this.destroyedCache.add(iPos);
                } else {
                    this.blocksToUpdate.add(iPos);
                }
                r = 10.0;
            } else {
                if (block instanceof IFluidBlock || block instanceof FallingBlock) {
                    this.blocksToUpdate.add(iPos);
                }
                this.scannedCache.add(iPos);
            }
            if (r > 1000.0) {
                r = 1000.0;
            }
        } else {
            this.scannedCache.add(iPos);
        }
        r = r / (double)this.radius / (double)travel;
        totalResist += r;
        power -= r;
        if (dist == 1 && traceDir == -1 && this.lava && this.world.func_201674_k().nextInt(250) == 0 && !this.world.func_175623_d(pos.func_177977_b())) {
            dist = 0;
            if (this.destroyedCache.contains(iPos)) {
                this.destroyedCache.remove(iPos);
            }
            this.lavaPositions.add(iPos);
            this.blocksToUpdate.add(iPos);
            this.scannedCache.add(iPos);
        }
        posVec.func_195905_a(posVec.func_195899_a(), posVec.func_195900_b() + (float)traceDir, posVec.func_195902_c());
        return this.trace(posVec, power, dist, traceDir, totalResist, travel);
    }

    public boolean isCalculationComplete() {
        return this.calculationComplete;
    }

    public boolean detonate() {
        if (!this.isCalculationComplete() || this.detonated) {
            return false;
        }
        long l = System.currentTimeMillis();
        IndustrialForegoing.LOGGER.debug("Removing Blocks!");
        BlockPos pos = new BlockPos((double)this.origin.func_195899_a(), (double)this.origin.func_195900_b(), (double)this.origin.func_195902_c());
        new Thread(() -> {
            List list = this.world.func_217357_a(Entity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)this.radius * 2.5, (double)this.radius * 2.5, (double)this.radius * 2.5));
            for (Entity e : list) {
                if (e instanceof CatEntity) continue;
                float dmg = 10000.0f;
                if (e instanceof PlayerEntity) {
                    for (int i = 0; i < 100; ++i) {
                        e.func_70097_a(fusionExplosion, 100.0f);
                    }
                    continue;
                }
                e.func_70097_a(fusionExplosion, dmg);
            }
        }).start();
        ExplosionHelper removalHelper = new ExplosionHelper(this.world, new BlockPos((double)this.origin.func_195899_a(), (double)this.origin.func_195900_b(), (double)this.origin.func_195902_c()), this.shortPos);
        int i = 0;
        removalHelper.setBlocksForRemoval(this.destroyedBlocks);
        for (Integer posI : this.lavaPositions) {
            this.world.func_175656_a(this.shortPos.getActualPos(posI), this.lavaState);
        }
        removalHelper.addBlocksForUpdate(this.blocksToUpdate);
        IndustrialForegoing.LOGGER.debug("Blocks Removed: " + i);
        removalHelper.finish();
        this.isDead = true;
        this.detonated = true;
        IndustrialForegoing.LOGGER.debug("Total explosion time: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "s");
        return true;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

