/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.deserializer.ItemPredicateDeserializer;

public class OutcomeMaterial {
    private static final Logger logger = LogManager.getLogger();
    public int count = 1;
    protected ItemStack itemStack;
    protected ResourceLocation tagLocation;
    private ItemPredicate predicate;

    public OutcomeMaterial offsetCount(float multiplier, int offset) {
        OutcomeMaterial result = new OutcomeMaterial();
        result.count = Math.round((float)this.count * multiplier) + offset;
        if (this.itemStack != null) {
            result.itemStack = this.itemStack.func_77946_l();
            result.itemStack.func_190920_e(result.count);
        }
        result.tagLocation = this.tagLocation;
        result.predicate = this.predicate;
        return result;
    }

    protected static ITagCollection<Item> getTagCollection() {
        if (FMLEnvironment.dist.isClient() && Minecraft.func_71410_x().field_71441_e != null) {
            return Minecraft.func_71410_x().field_71441_e.func_205772_D().func_241836_b();
        }
        return TagCollectionManager.func_242178_a().func_241836_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent[] getDisplayNames() {
        if (this.getPredicate() == null) {
            return new ITextComponent[]{new StringTextComponent("Unknown material")};
        }
        if (this.itemStack != null) {
            return new ITextComponent[]{this.itemStack.func_200301_q()};
        }
        if (this.tagLocation != null) {
            return (ITextComponent[])OutcomeMaterial.getTagCollection().func_241834_b(this.tagLocation).func_230236_b_().stream().map(item -> item.func_200295_i(item.func_190903_i())).toArray(ITextComponent[]::new);
        }
        return new ITextComponent[]{new StringTextComponent("Unknown material")};
    }

    public ItemStack[] getApplicableItemStacks() {
        if (this.getPredicate() == null) {
            return new ItemStack[0];
        }
        if (this.itemStack != null && !this.itemStack.func_190926_b()) {
            return new ItemStack[]{this.itemStack};
        }
        if (this.tagLocation != null) {
            return (ItemStack[])OutcomeMaterial.getTagCollection().func_241834_b(this.tagLocation).func_230236_b_().stream().map(Item::func_190903_i).map(this::setCount).toArray(ItemStack[]::new);
        }
        return new ItemStack[0];
    }

    @Nullable
    public ItemPredicate getPredicate() {
        return this.predicate;
    }

    private ItemStack setCount(ItemStack itemStack) {
        itemStack.func_190920_e(this.count);
        return itemStack;
    }

    public boolean isTagged() {
        return this.tagLocation != null;
    }

    public boolean isValid() {
        return this.predicate != null;
    }

    public static class Deserializer
    implements JsonDeserializer<OutcomeMaterial> {
        public OutcomeMaterial deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) {
            OutcomeMaterial material = new OutcomeMaterial();
            if (element != null && !element.isJsonNull()) {
                JsonObject jsonObject = JSONUtils.func_151210_l((JsonElement)element, (String)"material");
                material.count = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"count", (int)1);
                jsonObject.remove("count");
                if (jsonObject.has("item")) {
                    try {
                        Item item = JSONUtils.func_188180_i((JsonObject)jsonObject, (String)"item");
                        material.itemStack = new ItemStack((IItemProvider)item, material.count);
                    }
                    catch (JsonSyntaxException item) {
                        // empty catch block
                    }
                    if (material.itemStack != null && jsonObject.has("nbt")) {
                        try {
                            CompoundNBT compoundnbt = JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)jsonObject.get("nbt"), (String)"nbt"));
                            material.itemStack.func_77982_d(compoundnbt);
                        }
                        catch (CommandSyntaxException exception) {
                            throw new JsonSyntaxException("Encountered invalid nbt tag when parsing material: " + exception.getMessage());
                        }
                    }
                } else if (jsonObject.has("tag")) {
                    material.tagLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
                }
                if (!jsonObject.has("type") && jsonObject.has("tag")) {
                    material.predicate = this.deserializeTagPredicate(element);
                } else {
                    material.predicate = ItemPredicateDeserializer.deserialize(element);
                }
            }
            return material;
        }

        private ItemPredicate deserializeTagPredicate(@Nullable JsonElement element) {
            JsonObject jsonObject = JSONUtils.func_151210_l((JsonElement)element, (String)"item");
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
            ITag tag = OutcomeMaterial.getTagCollection().func_199910_a(resourceLocation);
            if (tag == null) {
                logger.debug("Failed to parse outcome material predicate for \"{}\": Unknown tag '{}'", (Object)jsonObject.toString(), (Object)resourceLocation);
                return null;
            }
            MinMaxBounds.IntBound count = MinMaxBounds.IntBound.func_211344_a((JsonElement)jsonObject.get("count"));
            MinMaxBounds.IntBound durability = MinMaxBounds.IntBound.func_211344_a((JsonElement)jsonObject.get("durability"));
            EnchantmentPredicate[] enchantments = EnchantmentPredicate.func_192465_b((JsonElement)jsonObject.get("enchantments"));
            EnchantmentPredicate[] storedEnchantments = EnchantmentPredicate.func_192465_b((JsonElement)jsonObject.get("stored_enchantments"));
            NBTPredicate nbt = NBTPredicate.func_193476_a((JsonElement)jsonObject.get("nbt"));
            return new ItemPredicate(tag, null, count, durability, enchantments, storedEnchantments, null, nbt);
        }
    }
}

