/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.CastOptional;

public class SlamEffect
extends ChargedAbilityEffect {
    public static final SlamEffect instance = new SlamEffect();

    SlamEffect() {
        super(10, 1.0, 40, 6.0, ItemEffect.slam, ChargedAbilityEffect.TargetRequirement.either, UseAction.SPEAR, "raised");
    }

    @Override
    public int getChargeTime(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack) {
        if (ComboPoints.canSpend(item, itemStack)) {
            return (int)((double)super.getChargeTime(attacker, item, itemStack) * (1.0 - (double)item.getEffectLevel(itemStack, ItemEffect.abilityCombo) / 100.0 * (double)ComboPoints.get((Entity)attacker)));
        }
        return super.getChargeTime(attacker, item, itemStack);
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vector3d hitVec, int chargedTicks) {
        AbilityUseResult result = this.directSlam(attacker, hand, item, itemStack, target, hitVec, chargedTicks);
        double overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend);
        attacker.func_71020_j(overextendLevel > 0.0 ? 6.0f : 1.0f);
        attacker.func_226292_a_(hand, false);
        attacker.func_184811_cZ().func_185145_a((Item)item, Math.round((float)this.getCooldown(item, itemStack) * 1.5f));
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        if (revengeLevel > 0) {
            RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
        }
        item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
        int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
        if (echoLevel > 0) {
            this.echoTarget(attacker, hand, item, itemStack, target, hitVec, chargedTicks);
        }
    }

    public AbilityUseResult directSlam(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vector3d hitVec, int chargedTicks) {
        AbilityUseResult result;
        double overextendLevel;
        double momentumEfficiency;
        int momentumLevel;
        int stunDuration = 0;
        double damageMultiplier = (double)item.getEffectLevel(itemStack, ItemEffect.slam) * 1.5 / 100.0;
        float knockbackBase = (float)item.getEffectEfficiency(itemStack, ItemEffect.slam);
        float knockbackMultiplier = 1.0f;
        boolean isDefensive = this.isDefensive(item, itemStack, hand);
        int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        if (isDefensive) {
            damageMultiplier -= 0.3;
            stunDuration = item.getEffectLevel(itemStack, ItemEffect.abilityDefensive);
        }
        if (overchargeBonus > 0) {
            double bonus = (double)(overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
            damageMultiplier += bonus;
            knockbackMultiplier = (float)((double)knockbackMultiplier + bonus);
        }
        if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0) {
            stunDuration = momentumLevel;
        }
        if ((momentumEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum)) > 0.0) {
            knockbackMultiplier = 0.4f;
        }
        if ((overextendLevel = (double)item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0.0 && !attacker.func_71024_bL().func_75121_c()) {
            damageMultiplier += overextendLevel / 100.0;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, knockbackMultiplier * knockbackBase, knockbackMultiplier / 2.0f)) != AbilityUseResult.fail) {
            double exhilarationEfficiency;
            if (stunDuration > 0) {
                target.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, stunDuration, 0, false, false));
            }
            if (momentumEfficiency > 0.0) {
                double velocity = momentumEfficiency;
                target.func_70024_g(0.0, velocity *= 1.0 - target.func_233637_b_(Attributes.field_233820_c_), 0.0);
            }
            if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
                target.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, revengeLevel, 0, false, false));
            }
            if ((exhilarationEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityExhilaration)) > 0.0) {
                this.knockbackExhilaration(attacker, attacker.func_213303_ch(), target, target.field_70170_p.func_82737_E() + 200L, exhilarationEfficiency);
            }
            Random rand = target.func_70681_au();
            CastOptional.cast(target.field_70170_p, ServerWorld.class).ifPresent(world -> world.func_195598_a((IParticleData)ParticleTypes.field_197614_g, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, 10, rand.nextGaussian() * 0.3, rand.nextGaussian() * (double)target.func_213302_cg() * 0.8, rand.nextGaussian() * 0.3, (double)0.1f));
            target.func_130014_f_().func_184133_a(attacker, target.func_233580_cy_(), SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 0.7f);
        } else {
            target.func_130014_f_().func_184133_a(attacker, target.func_233580_cy_(), SoundEvents.field_187733_dX, SoundCategory.PLAYERS, 1.0f, 0.7f);
        }
        return result;
    }

    private void knockbackExhilaration(PlayerEntity attacker, Vector3d origin, LivingEntity target, long timeLimit, double multiplier) {
        ServerScheduler.schedule(20, () -> {
            if (target.func_233570_aj_()) {
                double distance = Math.min(20.0, origin.func_72438_d(target.func_213303_ch()));
                int amplifier = (int)(distance * multiplier) - 1;
                if (amplifier >= 0) {
                    attacker.func_195064_c(new EffectInstance((Effect)SmallStrengthPotionEffect.instance, 200, amplifier, false, true));
                }
            } else if (target.field_70170_p.func_82737_E() < timeLimit) {
                this.knockbackExhilaration(attacker, origin, target, timeLimit, multiplier);
            }
        });
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, BlockPos targetPos, Vector3d hitVec, int chargedTicks) {
        if (!attacker.field_70170_p.field_72995_K) {
            int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
            int slowDuration = this.isDefensive(item, itemStack, hand) ? (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) * 20.0) : 0;
            double momentumEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum);
            int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
            double overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend);
            double range = this.getAoeRange(attacker, item, itemStack, overchargeBonus);
            Vector3d direction = hitVec.func_178788_d(attacker.func_213303_ch()).func_216372_d(1.0, 0.0, 1.0).func_72432_b();
            double yaw = MathHelper.func_181159_b((double)direction.field_72450_a, (double)direction.field_72449_c);
            AxisAlignedBB boundingBox = new AxisAlignedBB(hitVec, hitVec).func_72314_b(range + 1.0, 4.0, range + 1.0).func_191194_a(direction.func_186678_a(range / 2.0));
            List<LivingEntity> targets = attacker.field_70170_p.func_217357_a(LivingEntity.class, boundingBox).stream().filter(Entity::func_70089_S).filter(Entity::func_70075_an).filter(entity -> !attacker.equals(entity)).filter(entity -> this.inRange(hitVec, (Entity)entity, yaw, range)).collect(Collectors.toList());
            double damageMultiplier = this.getAoeDamageMultiplier(attacker, item, itemStack, slowDuration > 0, overchargeBonus, targets);
            targets.forEach(entity -> SlamEffect.groundSlamEntity(attacker, entity, item, itemStack, hitVec, damageMultiplier, slowDuration, momentumEfficiency, revengeLevel));
            this.spawnGroundParticles(attacker.field_70170_p, hitVec, direction, yaw, range);
            attacker.func_71020_j(overextendLevel > 0.0 ? 6.0f : 1.0f);
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                this.echoGround(attacker, item, itemStack, hitVec, direction, yaw, range, damageMultiplier * (double)echoLevel / 100.0, slowDuration, momentumEfficiency, revengeLevel);
            }
        }
        attacker.func_226292_a_(hand, false);
        attacker.func_184811_cZ().func_185145_a((Item)item, this.getCooldown(item, itemStack));
        item.tickProgression((LivingEntity)attacker, itemStack, 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private void echoGround(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, Vector3d hitVec, Vector3d direction, double yaw, double range, double damageMultiplier, int slowDuration, double momentumEfficiency, int revengeLevel) {
        EchoHelper.echo(attacker, 60, () -> {
            AxisAlignedBB boundingBox = new AxisAlignedBB(hitVec, hitVec).func_72314_b(range + 1.0, 4.0, range + 1.0).func_191194_a(direction.func_186678_a(range / 2.0));
            List<LivingEntity> targets = attacker.field_70170_p.func_217357_a(LivingEntity.class, boundingBox).stream().filter(Entity::func_70089_S).filter(Entity::func_70075_an).filter(entity -> this.inRange(hitVec, (Entity)entity, yaw, range)).collect(Collectors.toList());
            targets.forEach(entity -> SlamEffect.groundSlamEntity(attacker, entity, item, itemStack, hitVec, damageMultiplier, slowDuration, momentumEfficiency, revengeLevel));
            this.spawnGroundParticles(attacker.field_70170_p, hitVec, direction, yaw, range);
        });
    }

    private void echoTarget(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vector3d hitVec, int chargedTicks) {
        if (!attacker.field_70170_p.field_72995_K) {
            EchoHelper.echo(attacker, 60, () -> {
                this.directSlam(attacker, hand, item, itemStack, target, hitVec, chargedTicks);
                int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
                if (revengeLevel > 0) {
                    RevengeTracker.removeEnemySynced((ServerPlayerEntity)attacker, (Entity)target);
                }
            });
        }
    }

    private double getAoeDamageMultiplier(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, boolean isDefensive, int overchargeBonus, List<LivingEntity> targets) {
        int exhilarationLevel;
        double overextendLevel;
        double damageMultiplier = (float)item.getEffectLevel(itemStack, ItemEffect.slam) / 100.0f;
        if (isDefensive) {
            damageMultiplier -= 0.3;
        }
        if (overchargeBonus > 0) {
            damageMultiplier += (double)(overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
        }
        if ((overextendLevel = (double)item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0.0 && !attacker.func_71024_bL().func_75121_c()) {
            damageMultiplier += overextendLevel / 100.0;
        }
        if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0) {
            damageMultiplier += (double)(targets.size() * exhilarationLevel) / 100.0;
        }
        return damageMultiplier;
    }

    private double getAoeRange(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, int overchargeBonus) {
        double overextendEfficiency;
        double range = 8.0;
        if (overchargeBonus > 0) {
            range += (double)overchargeBonus * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge);
        }
        if ((overextendEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityOverextend)) > 0.0 && !attacker.func_71024_bL().func_75121_c()) {
            range += overextendEfficiency;
        }
        return range;
    }

    private void spawnGroundParticles(World world, Vector3d origin, Vector3d direction, double yaw, double range) {
        Random rand = world.field_73012_v;
        BlockState originState = world.func_180495_p(new BlockPos(origin));
        ((ServerWorld)world).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, originState), origin.func_82615_a(), origin.func_82617_b(), origin.func_82616_c(), 8, 0.0, rand.nextGaussian() * 0.1, 0.0, 0.1);
        world.func_184133_a(null, new BlockPos(origin), originState.func_215695_r().func_185845_c(), SoundCategory.PLAYERS, 1.5f, 0.5f);
        int bound = (int)Math.ceil(range / 2.0);
        BlockPos center = new BlockPos(origin.func_178787_e(direction.func_186678_a(range / 2.0)));
        origin = origin.func_178787_e(direction.func_186678_a(-1.0));
        BlockPos.Mutable targetPos = new BlockPos.Mutable(0, 0, 0);
        for (int x = -bound; x <= bound; ++x) {
            block1: for (int z = -bound; z <= bound; ++z) {
                targetPos.func_239621_a_((Vector3i)center, x, 0, z);
                if (!this.compareAngle(origin, targetPos, yaw)) continue;
                for (int y = -2; y < 2; ++y) {
                    targetPos.func_239621_a_((Vector3i)center, x, y, z);
                    BlockState targetState = world.func_180495_p((BlockPos)targetPos);
                    if (!targetState.func_200132_m() || world.func_180495_p(targetPos.func_177984_a()).func_200132_m()) continue;
                    targetPos.func_177977_b();
                    double distance = targetPos.func_218140_a(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, true);
                    if (!(distance < range * range)) continue block1;
                    double yOffset = targetState.func_196954_c((IBlockReader)world, (BlockPos)targetPos).func_197752_a().field_72337_e;
                    BlockPos particlePos = targetPos.func_185334_h();
                    ServerScheduler.schedule(particlePos.func_218139_n((Vector3i)new BlockPos(origin)) - 3, () -> {
                        ((ServerWorld)world).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, targetState), (double)particlePos.func_177958_n() + 0.5, (double)particlePos.func_177956_o() + yOffset, (double)particlePos.func_177952_p() + 0.5, 3, 0.0, rand.nextGaussian() * 0.1, 0.0, 0.1);
                        if (rand.nextFloat() < 0.3f) {
                            world.func_184133_a(null, particlePos, targetState.func_215695_r().func_185842_g(), SoundCategory.PLAYERS, 1.0f, 0.5f);
                        }
                    });
                    continue block1;
                }
            }
        }
    }

    private boolean inRange(Vector3d origin, Entity entity, double originYaw, double range) {
        if (origin.func_237488_a_((IPosition)entity.func_213303_ch(), range)) {
            Vector3d direction = entity.func_213303_ch().func_178788_d(origin);
            double entityYaw = MathHelper.func_181159_b((double)direction.field_72450_a, (double)direction.field_72449_c);
            double yawDiff = Math.abs((originYaw - entityYaw + Math.PI * 3) % (Math.PI * 2) - Math.PI);
            return yawDiff < 0.5235987755982988;
        }
        return false;
    }

    private boolean compareAngle(Vector3d originPos, BlockPos.Mutable offsetPos, double originYaw) {
        Vector3d direction = Vector3d.func_237492_c_((Vector3i)offsetPos).func_178788_d(originPos);
        double offsetYaw = MathHelper.func_181159_b((double)direction.func_82615_a(), (double)direction.func_82616_c());
        double yawDiff = Math.abs((originYaw - offsetYaw + Math.PI * 3) % (Math.PI * 2) - Math.PI);
        return yawDiff < 0.5235987755982988;
    }

    private static void groundSlamEntity(PlayerEntity attacker, LivingEntity target, ItemModularHandheld item, ItemStack itemStack, Vector3d origin, double damageMultiplier, int slowDuration, double momentumEfficiency, int revengeLevel) {
        ServerScheduler.schedule(target.func_233580_cy_().func_218139_n((Vector3i)new BlockPos(origin)) - 3, () -> {
            float knockback = momentumEfficiency > 0.0 ? 0.1f : 0.5f;
            AbilityUseResult result = item.hitEntity(itemStack, attacker, target, damageMultiplier, knockback, knockback);
            if (momentumEfficiency > 0.0) {
                target.func_130014_f_().func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187655_bw, SoundCategory.PLAYERS, 1.0f, 0.7f);
            } else {
                target.func_130014_f_().func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 0.9f);
            }
            if (result != AbilityUseResult.fail) {
                if (slowDuration > 0) {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, slowDuration, 1, false, true));
                }
                if (momentumEfficiency > 0.0) {
                    double velocity = momentumEfficiency;
                    target.func_70024_g(0.0, velocity *= 1.0 - target.func_233637_b_(Attributes.field_233820_c_), 0.0);
                    target.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, 40, 0, false, false));
                }
                if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
                    target.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, revengeLevel, 0, false, false));
                    RevengeTracker.removeEnemySynced((ServerPlayerEntity)attacker, (Entity)target);
                }
            }
            if (result == AbilityUseResult.crit) {
                Random rand = target.func_70681_au();
                CastOptional.cast(target.field_70170_p, ServerWorld.class).ifPresent(world -> world.func_195598_a((IParticleData)ParticleTypes.field_197614_g, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 10, rand.nextGaussian() * 0.3, rand.nextGaussian() * 0.5, rand.nextGaussian() * 0.3, (double)0.1f));
            }
        });
    }
}

