/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.server.ServerWorld;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.EchoHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.PriedPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.ParticleHelper;

public class PryEffect {
    public static final double flatCooldown = 2.0;
    public static final double cooldownSpeedMultiplier = 3.0;
    public static final double damageMultiplier = 0.5;

    private static int getCooldown(ItemModularHandheld item, ItemStack itemStack) {
        float speedBonus = (float)(100 - item.getEffectLevel(itemStack, ItemEffect.abilitySpeed)) / 100.0f;
        return (int)((2.0 + item.getCooldownBase(itemStack) * 3.0) * (double)speedBonus * 20.0);
    }

    public static void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, int effectLevel, LivingEntity target) {
        int revengeLevel;
        if (!attacker.field_70170_p.field_72995_K) {
            boolean isSatiated;
            int comboPoints = ComboPoints.get((Entity)attacker);
            boolean bl = isSatiated = !attacker.func_71024_bL().func_75121_c();
            if (hand == Hand.OFF_HAND && item.getEffectLevel(itemStack, ItemEffect.abilityDefensive) > 0) {
                PryEffect.performDefensive(attacker, item, itemStack, target);
            } else {
                PryEffect.performRegular(attacker, item, itemStack, 0.5, effectLevel, target, isSatiated, comboPoints);
            }
            target.func_130014_f_().func_184133_a(attacker, target.func_233580_cy_(), SoundEvents.field_187733_dX, SoundCategory.PLAYERS, 0.8f, 0.8f);
            boolean overextended = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend) > 0;
            attacker.func_71020_j(overextended ? 6.0f : 0.5f);
            attacker.func_184811_cZ().func_185145_a((Item)item, PryEffect.getCooldown(item, itemStack));
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                PryEffect.performEcho(attacker, item, itemStack, 0.5, effectLevel, target, isSatiated, comboPoints);
            }
        }
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        if ((revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge)) > 0) {
            RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
        }
        attacker.func_226292_a_(hand, false);
        item.tickProgression((LivingEntity)attacker, itemStack, 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    public static AbilityUseResult performRegular(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, double damageMultiplier, int amplifier, LivingEntity target, boolean isSatiated, int comboPoints) {
        AbilityUseResult result;
        int amp;
        int exhilarationLevel;
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        int comboLevel = item.getEffectLevel(itemStack, ItemEffect.abilityCombo);
        if (comboLevel > 0) {
            damageMultiplier += (double)(comboLevel * comboPoints) / 100.0;
        }
        if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
            damageMultiplier += (double)revengeLevel / 100.0;
        }
        if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0 && (amp = Optional.ofNullable(target.func_70660_b((Effect)PriedPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1) + 1) > 0) {
            damageMultiplier += (double)(exhilarationLevel * amp) / 100.0;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.2f, 0.2f)) != AbilityUseResult.fail) {
            int momentumLevel;
            double overextendLevel;
            int currentAmplifier = Optional.ofNullable(target.func_70660_b((Effect)PriedPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1);
            double comboEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityCombo);
            if (comboEfficiency > 0.0 && (double)attacker.func_130014_f_().func_201674_k().nextFloat() < comboEfficiency * (double)comboPoints / 100.0) {
                ++amplifier;
                if (!target.func_130014_f_().field_72995_K) {
                    Random rand = target.func_130014_f_().func_201674_k();
                    ((ServerWorld)target.func_130014_f_()).func_195598_a((IParticleData)ParticleTypes.field_197614_g, target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_(), 10, rand.nextGaussian() * 0.3, rand.nextGaussian() * (double)target.func_213302_cg() * 0.8, rand.nextGaussian() * 0.3, (double)0.1f);
                }
            }
            if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
                ++amplifier;
            }
            if ((overextendLevel = (double)item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0.0 && isSatiated) {
                ++amplifier;
            }
            target.func_195064_c(new EffectInstance((Effect)PriedPotionEffect.instance, (int)(item.getEffectEfficiency(itemStack, ItemEffect.pry) * 20.0), currentAmplifier + amplifier, false, false));
            if (!target.func_130014_f_().field_72995_K) {
                ParticleHelper.spawnArmorParticles((ServerWorld)target.func_130014_f_(), target);
            }
            if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0 && currentAmplifier > -1) {
                int duration = momentumLevel * (currentAmplifier + 1);
                target.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, duration, 0, false, false));
            }
        }
        return result;
    }

    public static AbilityUseResult performDefensive(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target) {
        AbilityUseResult result = item.hitEntity(itemStack, attacker, target, 0.5, 0.2f, 0.2f);
        if (result != AbilityUseResult.fail) {
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, (int)(item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) * 20.0), item.getEffectLevel(itemStack, ItemEffect.abilityDefensive) - 1, false, true));
            if (!target.func_130014_f_().field_72995_K) {
                if (target.func_190630_a(EquipmentSlotType.MAINHAND)) {
                    ParticleHelper.spawnArmorParticles((ServerWorld)target.func_130014_f_(), target, EquipmentSlotType.MAINHAND);
                } else if (target.func_190630_a(EquipmentSlotType.OFFHAND)) {
                    ParticleHelper.spawnArmorParticles((ServerWorld)target.func_130014_f_(), target, EquipmentSlotType.OFFHAND);
                }
            }
        }
        return result;
    }

    public static void performEcho(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, double damageMultiplier, int amplifier, LivingEntity target, boolean isSatiated, int comboPoints) {
        EchoHelper.echo(attacker, 60, () -> {
            PryEffect.performRegular(attacker, item, itemStack, damageMultiplier, amplifier, target, isSatiated, comboPoints);
            int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
            if (revengeLevel > 0) {
                RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
            }
        });
    }
}

