/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.effect.ArmorPenetrationEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.CrushingEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.LungeEffect;
import se.mickelus.tetra.effect.SeveringEffect;
import se.mickelus.tetra.effect.SkeweringEffect;
import se.mickelus.tetra.effect.StrikingEffect;
import se.mickelus.tetra.effect.StunEffect;
import se.mickelus.tetra.effect.SweepingEffect;
import se.mickelus.tetra.effect.howling.HowlingEffect;
import se.mickelus.tetra.effect.potion.BleedingPotionEffect;
import se.mickelus.tetra.effect.potion.EarthboundPotionEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuiverInventory;
import se.mickelus.tetra.properties.PropertyHelper;
import se.mickelus.tetra.util.CastOptional;

public class ItemEffectHandler {
    public static ItemEffectHandler instance;

    public ItemEffectHandler() {
        instance = this;
    }

    public static void applyHitEffects(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        int stunLevel;
        int earthbindLevel;
        int severLevel;
        int bleedingLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.bleeding);
        if (bleedingLevel > 0 && !CreatureAttribute.field_223223_b_.equals(target.func_70668_bt()) && attacker.func_70681_au().nextFloat() < 0.3f) {
            target.func_195064_c(new EffectInstance((Effect)BleedingPotionEffect.instance, 40, bleedingLevel));
        }
        if ((severLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.severing)) > 0) {
            SeveringEffect.perform(itemStack, severLevel, attacker, target);
        }
        if ((earthbindLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.earthbind)) > 0 && (double)attacker.func_70681_au().nextFloat() < Math.max(0.1, 0.5 * (1.0 - target.func_226278_cu_() / 128.0))) {
            target.func_195064_c(new EffectInstance((Effect)EarthboundPotionEffect.instance, earthbindLevel * 20, 0, false, true));
            if (target.field_70170_p instanceof ServerWorld) {
                BlockState blockState = target.field_70170_p.func_180495_p(new BlockPos(target.func_226277_ct_(), target.func_226278_cu_() - 1.0, target.func_226281_cx_()));
                ((ServerWorld)target.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), target.func_226277_ct_(), target.func_226278_cu_() + 0.1, target.func_226281_cx_(), 16, 0.0, target.field_70170_p.field_73012_v.nextGaussian() * 0.2, 0.0, 0.1);
            }
        }
        if ((stunLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.stun)) > 0) {
            StunEffect.perform(itemStack, stunLevel, attacker, target);
        }
    }

    private static int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        return EffectHelper.getEffectLevel(itemStack, effect);
    }

    private static double getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        return EffectHelper.getEffectEfficiency(itemStack, effect);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        Optional.ofNullable(event.getAttackingPlayer()).map(LivingEntity::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof IModularItem).ifPresent(itemStack -> {
            int intuitLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.intuit);
            int xp = event.getDroppedExperience();
            if (intuitLevel > 0 && xp > 0) {
                ((IModularItem)itemStack.func_77973_b()).tickHoningProgression((LivingEntity)event.getAttackingPlayer(), (ItemStack)itemStack, intuitLevel * xp);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttackEntity(AttackEntityEvent event) {
        if (!event.isCanceled()) {
            ComboPoints.onAttackEntity(event);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (!event.getSource().func_76363_c() && event.getEntityLiving().func_184585_cz()) {
            Optional.ofNullable(event.getEntityLiving()).map(LivingEntity::func_184607_cu).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModularHandheld).ifPresent(itemStack -> {
                ItemModularHandheld item = (ItemModularHandheld)itemStack.func_77973_b();
                LivingEntity blocker = event.getEntityLiving();
                if (UseAction.BLOCK.equals((Object)itemStack.func_77975_n())) {
                    item.applyUsageEffects(blocker, (ItemStack)itemStack, MathHelper.func_76123_f((float)(event.getAmount() / 2.0f)));
                }
                if (event.getSource().func_76364_f() instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)event.getSource().func_76364_f();
                    if ((float)item.getEffectLevel((ItemStack)itemStack, ItemEffect.blockingReflect) > attacker.func_70681_au().nextFloat() * 100.0f) {
                        attacker.func_70097_a((DamageSource)new EntityDamageSource("thorns", (Entity)blocker).func_180138_v(), (float)(item.getAbilityBaseDamage((ItemStack)itemStack) * item.getEffectEfficiency((ItemStack)itemStack, ItemEffect.blockingReflect)));
                        ItemEffectHandler.applyHitEffects(itemStack, attacker, blocker);
                        EffectHelper.applyEnchantmentHitEffects(itemStack, attacker, blocker);
                        float knockbackFactor = 0.5f + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)itemStack);
                        attacker.func_233627_a_(knockbackFactor * 0.5f, blocker.func_226277_ct_() - attacker.func_226277_ct_(), blocker.func_226281_cx_() - attacker.func_226281_cx_());
                    }
                }
            });
        }
        if ("arrow".equals(event.getSource().field_76373_n)) {
            CastOptional.cast(event.getSource().func_76346_g(), LivingEntity.class).map(shooter -> Stream.of(shooter.func_184614_ca(), shooter.func_184592_cb())).orElseGet(Stream::empty).filter(itemStack -> itemStack.func_77973_b() instanceof ModularBowItem).findFirst().ifPresent(itemStack -> {
                ModularBowItem item = (ModularBowItem)itemStack.func_77973_b();
                item.tickHoningProgression((LivingEntity)event.getSource().func_76346_g(), (ItemStack)itemStack, 2);
            });
        }
        RevengeTracker.onAttackEntity(event);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (TickEvent.Phase.START == event.phase) {
            LungeEffect.onPlayerTick(event.player);
        }
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent.Arrow event) {
        HowlingEffect.deflectProjectile((ProjectileImpactEvent)event, (ProjectileEntity)event.getArrow(), event.getRayTraceResult());
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Optional.ofNullable(event.getSource().func_76346_g()).filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).map(LivingEntity::func_184614_ca).filter(itemStack -> itemStack.func_77973_b() instanceof IModularItem).ifPresent(itemStack -> {
            int armorPenetrationLevel;
            int quickStrikeLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.quickStrike);
            if (quickStrikeLevel > 0) {
                float maxDamage = (float)((LivingEntity)event.getSource().func_76346_g()).func_110148_a(Attributes.field_233823_f_).func_111126_e();
                float multiplier = (float)quickStrikeLevel * 0.05f + 0.2f;
                if (event.getAmount() < multiplier * maxDamage) {
                    event.setAmount(multiplier * maxDamage);
                }
            }
            if ((armorPenetrationLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.armorPenetration)) > 0) {
                ArmorPenetrationEffect.onLivingHurt(event, armorPenetrationLevel);
            }
        });
        if (!event.getSource().func_76363_c()) {
            Optional.ofNullable(event.getEntityLiving()).map(entity -> Stream.of(entity.func_184614_ca(), entity.func_184592_cb())).orElseGet(Stream::empty).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModularHandheld).forEach(itemStack -> {
                ItemModularHandheld item = (ItemModularHandheld)itemStack.func_77973_b();
                if (item.getAttributeValue((ItemStack)itemStack, Attributes.field_233826_i_) > 0.0 || item.getAttributeValue((ItemStack)itemStack, Attributes.field_233827_j_) > 0.0) {
                    int reducedAmount = (int)Math.ceil(event.getAmount() - CombatRules.func_189427_a((float)event.getAmount(), (float)event.getEntityLiving().func_70658_aO(), (float)((float)event.getEntityLiving().func_110148_a(Attributes.field_233827_j_).func_111126_e())));
                    item.applyUsageEffects(event.getEntityLiving(), (ItemStack)itemStack, reducedAmount);
                    item.applyDamage(reducedAmount, (ItemStack)itemStack, event.getEntityLiving());
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        Optional.ofNullable(event.getSource().func_76346_g()).filter(entity -> entity instanceof PlayerEntity).map(entity -> (LivingEntity)entity).map(LivingEntity::func_184614_ca).filter(itemStack -> itemStack.func_77973_b() instanceof IModularItem).ifPresent(itemStack -> {
            int skeweringLevel;
            int crushingLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.crushing);
            if (crushingLevel > 0) {
                CrushingEffect.onLivingDamage(event, crushingLevel);
            }
            if ((skeweringLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.skewering)) > 0) {
                SkeweringEffect.onLivingDamage(event, skeweringLevel, itemStack);
            }
        });
        ArmorPenetrationEffect.onLivingDamage(event);
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Optional.ofNullable(event.getEntityLiving().func_70660_b((Effect)EarthboundPotionEffect.instance)).ifPresent(effect -> event.getEntityLiving().func_213317_d(event.getEntityLiving().func_213322_ci().func_216372_d(1.0, 0.5, 1.0)));
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
        Optional.ofNullable(event.getEntityLiving()).map(LivingEntity::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof IModularItem).ifPresent(itemStack -> {
            int critLevel;
            int backstabLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.backstab);
            if (backstabLevel > 0 && event.getTarget() instanceof LivingEntity) {
                LivingEntity attacker = event.getEntityLiving();
                LivingEntity target = (LivingEntity)event.getTarget();
                if (180.0f - Math.abs(Math.abs(attacker.field_70759_as - target.field_70759_as) % 360.0f - 180.0f) < 60.0f) {
                    event.setDamageModifier(Math.max(1.25f + 0.25f * (float)backstabLevel, event.getDamageModifier()));
                    event.setResult(Event.Result.ALLOW);
                }
            }
            if ((critLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.criticalStrike)) > 0) {
                CritEffect.critEntity(event, itemStack, critLevel);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClickInput(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack itemStack = mc.field_71439_g.func_184614_ca();
        if (event.isAttack() && !event.isCanceled() && itemStack.func_77973_b() instanceof ItemModularHandheld && mc.field_71476_x != null && RayTraceResult.Type.MISS.equals((Object)mc.field_71476_x.func_216346_c())) {
            if (ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.truesweep) > 0) {
                SweepingEffect.triggerTruesweep();
            }
            if (ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.howling) > 0) {
                HowlingEffect.sendPacket();
            }
        }
        if (event.isUseItem()) {
            LungeEffect.onRightClick(mc.field_71439_g);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        KeyBinding jumpKey = Minecraft.func_71410_x().field_71474_y.field_74314_A;
        if (jumpKey.func_197976_a(event.getKey(), event.getScanCode()) && jumpKey.func_151470_d()) {
            LungeEffect.onJump(Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Optional.of(event.getItemStack()).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModularHandheld).ifPresent(itemStack -> {
            ItemModularHandheld item = (ItemModularHandheld)itemStack.func_77973_b();
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            BlockState blockState = world.func_180495_p(pos);
            PlayerEntity breakingPlayer = event.getPlayer();
            boolean didStrike = StrikingEffect.causeEffect(breakingPlayer, itemStack, item, world, pos, blockState);
            if (didStrike) {
                event.setCanceled(true);
                return;
            }
            if (!event.getWorld().field_72995_K) {
                int critLevel = ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.criticalStrike);
                if (critLevel > 0 && CritEffect.critBlock(world, breakingPlayer, pos, blockState, itemStack, critLevel)) {
                    event.setCanceled(true);
                }
                if (breakingPlayer.func_184825_o(0.5f) > 0.9f) {
                    int howlingLevel;
                    if (ItemEffectHandler.getEffectLevel(itemStack, ItemEffect.truesweep) > 0 && breakingPlayer.func_233570_aj_() && !breakingPlayer.func_70051_ag()) {
                        SweepingEffect.truesweep(itemStack, (LivingEntity)breakingPlayer);
                    }
                    if ((howlingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.howling)) > 0) {
                        HowlingEffect.trigger(itemStack, (LivingEntity)breakingPlayer, howlingLevel);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ExhaustedPotionEffect.onBreakSpeed(event);
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            AxisAlignedBB aabb = new AxisAlignedBB(event.getTargetX() - 24.0, event.getTargetY() - 24.0, event.getTargetZ() - 24.0, event.getTargetX() + 24.0, event.getTargetY() + 24.0, event.getTargetZ() + 24.0);
            event.getEntity().func_130014_f_().func_217357_a(PlayerEntity.class, aabb).forEach(player -> {
                double effectProbability;
                int reverbLevel = PropertyHelper.getPlayerEffectLevel(player, ItemEffect.enderReverb);
                if (reverbLevel > 0 && !player.func_184812_l_() && (effectProbability = PropertyHelper.getPlayerEffectEfficiency(player, ItemEffect.enderReverb)) > 0.0 && player.func_70681_au().nextDouble() < effectProbability * 2.0) {
                    player.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
                    player.func_195064_c(new EffectInstance(Effects.field_76431_k, 40 * reverbLevel));
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onArrowNock(ArrowNockEvent event) {
        ItemStack itemStack;
        PlayerEntity player = event.getPlayer();
        if (!event.hasAmmo() && player.func_184586_b(Hand.OFF_HAND).func_190926_b() && !(itemStack = ToolbeltHelper.findToolbelt(player)).func_190926_b()) {
            QuiverInventory inventory = new QuiverInventory(itemStack);
            List<Collection<ItemEffect>> effects = inventory.getSlotEffects();
            int count = CastOptional.cast(event.getBow().func_77973_b(), IModularItem.class).map(item -> ItemEffectHandler.getEffectLevel(event.getBow(), ItemEffect.multishot)).filter(level -> level > 0).orElse(1);
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!effects.get(i).contains(ItemEffect.quickAccess) || inventory.func_70301_a(i).func_190926_b()) continue;
                player.func_184611_a(Hand.OFF_HAND, inventory.func_70301_a(i).func_77979_a(count));
                player.func_184598_c(event.getHand());
                inventory.func_70296_d();
                event.setAction(new ActionResult(ActionResultType.SUCCESS, (Object)event.getBow()));
                return;
            }
        }
    }
}

