/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadTESR;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadTile;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.salvage.TileBlockInteraction;
import se.mickelus.tetra.util.CastOptional;
import se.mickelus.tetra.util.TileEntityOptional;

public class HammerHeadBlock
extends TetraWaterloggedBlock
implements IInteractiveBlock {
    static final BlockInteraction[] interactions = new BlockInteraction[]{new TileBlockInteraction<HammerHeadTile>(ToolTypes.hammer, 4, Direction.EAST, 1.0f, 11.0f, 7.0f, 11.0f, HammerHeadTile.class, HammerHeadTile::isJammed, (world, pos, blockState, player, hand, hitFace) -> HammerHeadBlock.unjam(world, pos, player))};
    public static final String unlocalizedName = "hammer_head";
    public static final VoxelShape shape = HammerHeadBlock.func_208617_a((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape jamShape = HammerHeadBlock.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    @ObjectHolder(value="tetra:hammer_head")
    public static HammerHeadBlock instance;

    public HammerHeadBlock() {
        super(ForgedBlockCommon.propertiesNotSolid);
        this.setRegistryName(unlocalizedName);
        this.hasItem = false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        ClientRegistry.bindTileEntityRenderer(HammerHeadTile.type, HammerHeadTESR::new);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
    }

    private boolean isJammed(IBlockReader world, BlockPos pos) {
        return TileEntityOptional.from(world, pos, HammerHeadTile.class).map(HammerHeadTile::isJammed).orElse(false);
    }

    private static boolean unjam(World world, BlockPos pos, PlayerEntity playerEntity) {
        TileEntityOptional.from((IBlockReader)world, pos, HammerHeadTile.class).ifPresent(tile -> tile.setJammed(false));
        world.func_184133_a(playerEntity, pos, SoundEvents.field_187928_hb, SoundCategory.PLAYERS, 1.0f, 0.5f);
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
    }

    private boolean isFunctional(World world, BlockPos pos) {
        BlockPos basePos = pos.func_177984_a();
        boolean functionalBase = CastOptional.cast(world.func_180495_p(basePos).func_177230_c(), HammerBaseBlock.class).map(base -> base.isFunctional(world, basePos)).orElse(false);
        return functionalBase && !this.isJammed((IBlockReader)world, pos);
    }

    @Override
    public boolean canProvideTools(World world, BlockPos pos, BlockPos targetPos) {
        return pos.equals((Object)targetPos.func_177984_a());
    }

    @Override
    public Collection<ToolType> getTools(World world, BlockPos pos, BlockState blockState) {
        if (this.isFunctional(world, pos)) {
            return Collections.singletonList(ToolTypes.hammer);
        }
        return super.getTools(world, pos, blockState);
    }

    @Override
    public int getToolLevel(World world, BlockPos pos, BlockState blockState, ToolType toolType) {
        if (ToolTypes.hammer.equals(toolType) && this.isFunctional(world, pos)) {
            BlockPos basePos = pos.func_177984_a();
            HammerBaseBlock baseBlock = (HammerBaseBlock)world.func_180495_p(basePos).func_177230_c();
            return baseBlock.getHammerLevel(world, basePos);
        }
        return super.getToolLevel(world, pos, blockState, toolType);
    }

    @Override
    public ItemStack onCraftConsumeTool(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, String slot, boolean isReplacing, PlayerEntity player, ToolType requiredTool, int requiredLevel, boolean consumeResources) {
        BlockPos basePos = pos.func_177984_a();
        BlockState baseState = world.func_180495_p(basePos);
        ItemStack upgradedStack = CastOptional.cast(baseState.func_177230_c(), HammerBaseBlock.class).map(base -> base.applyCraftEffects(world, basePos, baseState, targetStack, slot, isReplacing, player, requiredTool, requiredLevel, consumeResources)).orElse(targetStack);
        if (consumeResources) {
            TileEntityOptional.from((IBlockReader)world, pos, HammerHeadTile.class).ifPresent(HammerHeadTile::activate);
            world.func_184133_a(player, pos, SoundEvents.field_187689_f, SoundCategory.PLAYERS, 0.2f, (float)(0.5 + Math.random() * 0.2));
        }
        return upgradedStack;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (this.isJammed((IBlockReader)world, pos) && rand.nextBoolean()) {
            boolean flipped = rand.nextBoolean();
            float x = (float)pos.func_177958_n() + (flipped ? (rand.nextBoolean() ? 0.1f : 0.9f) : rand.nextFloat());
            float z = (float)pos.func_177952_p() + (!flipped ? (rand.nextBoolean() ? 0.1f : 0.9f) : rand.nextFloat());
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, state), (double)x, (double)(pos.func_177956_o() + 1), (double)z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ItemStack onActionConsumeTool(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, ToolType requiredTool, int requiredLevel, boolean consumeResources) {
        BlockPos basePos = pos.func_177984_a();
        BlockState baseState = world.func_180495_p(basePos);
        ItemStack upgradedStack = CastOptional.cast(baseState.func_177230_c(), HammerBaseBlock.class).map(base -> base.applyActionEffects(world, basePos, baseState, targetStack, player, requiredTool, requiredLevel, consumeResources)).orElse(targetStack);
        if (consumeResources) {
            TileEntityOptional.from((IBlockReader)world, pos, HammerHeadTile.class).ifPresent(HammerHeadTile::activate);
            world.func_184133_a(player, pos, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.2f, (float)(0.5 + Math.random() * 0.2));
        }
        return upgradedStack;
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (Direction.UP.equals((Object)facing) && !HammerBaseBlock.instance.equals(facingState.func_177230_c())) {
            return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (context == ISelectionContext.func_216377_a()) {
            return jamShape;
        }
        if (this.isJammed(world, pos)) {
            return jamShape;
        }
        return shape;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HammerHeadTile();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(World world, BlockPos pos, BlockState blockState, Direction face, Collection<ToolType> tools) {
        if (this.isJammed((IBlockReader)world, pos) && face.func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL) {
            return interactions;
        }
        return new BlockInteraction[0];
    }
}

