/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseRenderer;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseTile;
import se.mickelus.tetra.blocks.forged.hammer.HammerEffect;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlock;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.salvage.InteractiveBlockOverlay;
import se.mickelus.tetra.blocks.salvage.TileBlockInteraction;
import se.mickelus.tetra.items.cell.ItemCellMagmatic;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.util.TileEntityOptional;

public class HammerBaseBlock
extends TetraBlock
implements IInteractiveBlock {
    public static final DirectionProperty facingProp = HorizontalBlock.field_185512_D;
    public static final String qualityImprovementKey = "quality";
    public static final String unlocalizedName = "hammer_base";
    @ObjectHolder(value="tetra:hammer_base")
    public static HammerBaseBlock instance;
    public static final BlockInteraction[] interactions;

    public HammerBaseBlock() {
        super(ForgedBlockCommon.propertiesNotSolid);
        this.setRegistryName(unlocalizedName);
        this.hasItem = true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{facingProp});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        ClientRegistry.bindTileEntityRenderer(HammerBaseTile.type, HammerBaseRenderer::new);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
        tooltip.add((ITextComponent)new StringTextComponent(" "));
        tooltip.add((ITextComponent)new TranslationTextComponent("block.multiblock_hint.1x2x1").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
    }

    public boolean isFunctional(World world, BlockPos pos) {
        return TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).map(HammerBaseTile::isFunctional).orElse(false);
    }

    public void consumeFuel(World world, BlockPos pos) {
        TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).ifPresent(HammerBaseTile::consumeFuel);
    }

    public int getHammerLevel(World world, BlockPos pos) {
        return TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).map(HammerBaseTile::getHammerLevel).orElse(0);
    }

    public static boolean removeModule(World world, BlockPos pos, BlockState blockState, @Nullable PlayerEntity player, @Nullable Hand hand, Direction hitFace, boolean isA) {
        ItemStack moduleStack = TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).map(te -> te.removeModule(isA)).map(ItemStack::new).orElse(null);
        if (moduleStack != null && !world.field_72995_K) {
            if (player != null && player.field_71071_by.func_70441_a(moduleStack)) {
                player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            } else {
                HammerBaseBlock.func_180635_a((World)world, (BlockPos)pos.func_177972_a(hitFace), (ItemStack)moduleStack);
            }
        }
        world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.6f);
        return true;
    }

    public ItemStack applyCraftEffects(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, String slot, boolean isReplacing, PlayerEntity player, ToolType requiredTool, int requiredLevel, boolean consumeResources) {
        int preciseLevel;
        if (consumeResources) {
            this.consumeFuel(world, pos);
        }
        if (isReplacing && (preciseLevel = TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).map(te -> te.getEffectLevel(HammerEffect.precise)).orElse(0).intValue()) > 0) {
            ItemStack upgradedStack = targetStack.func_77946_l();
            ItemModuleMajor.addImprovement(upgradedStack, slot, qualityImprovementKey, preciseLevel);
            return upgradedStack;
        }
        return targetStack;
    }

    public ItemStack applyActionEffects(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, ToolType requiredTool, int requiredLevel, boolean consumeResources) {
        if (consumeResources) {
            this.consumeFuel(world, pos);
        }
        return targetStack;
    }

    private Map<String, String> getAdvancementData(World world, BlockPos pos) {
        return TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).map(tile -> {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("functional", String.valueOf(tile.isFunctional()));
            Optional.ofNullable(tile.getEffect(true)).ifPresent(module -> result.put("moduleA", module.toString()));
            Optional.ofNullable(tile.getEffect(false)).ifPresent(module -> result.put("moduleB", module.toString()));
            return result;
        }).orElseGet(Collections::emptyMap);
    }

    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        Direction blockFacing = (Direction)blockState.func_177229_b((Property)facingProp);
        HammerBaseTile te = TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).orElse(null);
        ItemStack heldStack = player.func_184586_b(hand);
        Direction facing = rayTraceResult.func_216354_b();
        if (te == null) {
            return ActionResultType.FAIL;
        }
        if (blockFacing.func_176740_k().equals((Object)facing.func_176740_k())) {
            int slotIndex;
            int n = slotIndex = blockFacing.equals((Object)facing) ? 0 : 1;
            if (te.hasCellInSlot(slotIndex)) {
                ItemStack cell = te.removeCellFromSlot(slotIndex);
                if (player.field_71071_by.func_70441_a(cell)) {
                    player.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                } else {
                    HammerBaseBlock.func_180635_a((World)world, (BlockPos)pos.func_177972_a(facing), (ItemStack)cell);
                }
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.6f);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, world.func_180495_p(pos), ItemStack.field_190927_a, this.getAdvancementData(world, pos));
                }
                return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
            }
            if (heldStack.func_77973_b() instanceof ItemCellMagmatic) {
                te.putCellInSlot(heldStack, slotIndex);
                player.func_184611_a(hand, ItemStack.field_190927_a);
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.5f);
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, world.func_180495_p(pos), heldStack, this.getAdvancementData(world, pos));
                }
                return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
            }
        } else {
            boolean success;
            boolean isA = Rotation.CLOCKWISE_90.func_185831_a(blockFacing).equals((Object)facing);
            if (te.getEffect(isA) == null && (success = te.setModule(isA, heldStack.func_77973_b()))) {
                if (!player.field_70170_p.field_72995_K) {
                    BlockUseCriterion.trigger((ServerPlayerEntity)player, world.func_180495_p(pos), heldStack, this.getAdvancementData(world, pos));
                }
                world.func_184133_a(player, pos, SoundEvents.field_187614_cJ, SoundCategory.PLAYERS, 0.5f, 0.5f);
                heldStack.func_190918_g(1);
                if (world.field_72995_K) {
                    InteractiveBlockOverlay.markDirty();
                }
                return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
            }
        }
        return BlockInteraction.attemptInteraction(world, world.func_180495_p(pos), pos, player, hand, rayTraceResult);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.func_177230_c())) {
            TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).ifPresent(tile -> {
                for (int i = 0; i < 2; ++i) {
                    if (!tile.hasCellInSlot(i)) continue;
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.getStackInSlot(i).func_77946_l());
                }
                Stream.of(tile.getEffect(true), tile.getEffect(false)).filter(Objects::nonNull).map(HammerEffect::getItem).map(ItemStack::new).forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
            });
            TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).ifPresent(TileEntity::func_145843_s);
        }
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(World world, BlockPos pos, BlockState state, Direction face, Collection<ToolType> tools) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(world, pos, state, (Direction)state.func_177229_b((Property)facingProp), face, tools)).toArray(BlockInteraction[]::new);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HammerBaseTile();
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        TileEntityOptional.from((IBlockReader)world, currentPos, HammerBaseTile.class).ifPresent(HammerBaseTile::updateRedstonePower);
        if (Direction.DOWN.equals((Object)facing) && !HammerHeadBlock.instance.equals(facingState.func_177230_c())) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState headState = (BlockState)HammerHeadBlock.instance.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(pos.func_177977_b()).func_206886_c() == Fluids.field_204546_a));
        world.func_180501_a(pos.func_177977_b(), headState, 3);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()).func_196953_a(context)) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)facingProp, (Comparable)context.func_195992_f().func_176734_d());
        }
        return null;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileEntityOptional.from((IBlockReader)world, pos, HammerBaseTile.class).ifPresent(HammerBaseTile::updateRedstonePower);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)facingProp, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)facingProp)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)facingProp)));
    }

    static {
        interactions = new BlockInteraction[]{new TileBlockInteraction<HammerBaseTile>(ToolTypes.pry, 1, Direction.EAST, 5.0f, 11.0f, 10.0f, 12.0f, HammerBaseTile.class, tile -> tile.getEffect(true) != null, (world, pos, blockState, player, hand, hitFace) -> HammerBaseBlock.removeModule(world, pos, blockState, player, hand, hitFace, true)), new TileBlockInteraction<HammerBaseTile>(ToolTypes.pry, 1, Direction.WEST, 5.0f, 11.0f, 10.0f, 12.0f, HammerBaseTile.class, tile -> tile.getEffect(false) != null, (world, pos, blockState, player, hand, hitFace) -> HammerBaseBlock.removeModule(world, pos, blockState, player, hand, hitFace, false))};
    }
}

