/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.extractor;

import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseTile;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonUpdatePacket;
import se.mickelus.tetra.util.TileEntityOptional;

public class CoreExtractorPistonTile
extends TileEntity
implements ITickableTileEntity {
    @ObjectHolder(value="tetra:extractor_piston")
    public static TileEntityType<CoreExtractorPistonTile> type;
    static final long activationDuration = 105L;
    private static final int fillAmount = 40;
    private long endTime = Long.MAX_VALUE;

    public CoreExtractorPistonTile() {
        super(type);
    }

    public void activate() {
        if (!this.isActive()) {
            this.endTime = this.field_145850_b.func_82737_E() + 105L;
            if (!this.field_145850_b.field_72995_K) {
                TetraMod.packetHandler.sendToAllPlayersNear(new CoreExtractorPistonUpdatePacket(this.field_174879_c, this.endTime), this.field_174879_c, 64.0, (RegistryKey<World>)this.field_145850_b.func_234923_W_());
            }
        }
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isActive() {
        return this.endTime != Long.MAX_VALUE;
    }

    public float getProgress(float partialTicks) {
        if (this.isActive()) {
            return Math.min(1.0f, Math.max(0.0f, ((float)(this.field_145850_b.func_82737_E() + 105L - this.endTime) + partialTicks) / 105.0f));
        }
        return 0.0f;
    }

    public void func_73660_a() {
        if (this.endTime < this.field_145850_b.func_82737_E()) {
            this.endTime = Long.MAX_VALUE;
            if (!this.field_145850_b.field_72995_K) {
                TileEntityOptional.from((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(Direction.DOWN), CoreExtractorBaseTile.class).ifPresent(base -> base.fill(40));
                this.runEndEffects();
                this.func_70296_d();
            }
        }
    }

    private void runEndEffects() {
        if (this.field_145850_b instanceof ServerWorld) {
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.1, (double)this.field_174879_c.func_177952_p() + 0.5, 5, 0.0, 0.0, 0.0, (double)0.02f);
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.1f, 1.0f);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187768_dl, SoundCategory.BLOCKS, 0.2f, 0.5f);
    }
}

