/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.google.common.collect.Sets;
import com.lothrazar.cyclic.api.IHarvesterOverride;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilShape;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HarvestUtil {
    public static final Set<IHarvesterOverride> HARVEST_OVERRIDES = Sets.newIdentityHashSet();

    public static void harvestShape(World world, BlockPos pos, int radius) {
        List<BlockPos> shape = UtilShape.squareHorizontalFull(pos, radius);
        for (BlockPos p : shape) {
            HarvestUtil.tryHarvestSingle(world, p);
        }
    }

    public static boolean tryHarvestSingle(World world, BlockPos posCurrent) {
        BlockState newState;
        boolean updated;
        CropsBlock crop;
        Object defaultSeedDrop;
        int maxAge;
        BlockState blockState = world.func_180495_p(posCurrent);
        IHarvesterOverride applicable = null;
        for (IHarvesterOverride override : HARVEST_OVERRIDES) {
            if (!override.appliesTo(blockState, world, posCurrent)) continue;
            applicable = override;
            break;
        }
        if (applicable != null) {
            return applicable.attemptHarvest(blockState, world, posCurrent, stack -> UtilItemStack.drop(world, posCurrent, blockState.func_177230_c()));
        }
        if (HarvestUtil.simpleBreakDrop(blockState)) {
            UtilItemStack.drop(world, posCurrent, blockState.func_177230_c());
            world.func_175655_b(posCurrent, false);
            return true;
        }
        if (world.func_180495_p(posCurrent).func_177230_c() instanceof StemBlock) {
            return false;
        }
        IntegerProperty propInt = HarvestUtil.getAgeProp(blockState);
        if (propInt == null || !(world instanceof ServerWorld)) {
            return false;
        }
        int currentAge = (Integer)blockState.func_177229_b((Property)propInt);
        int minAge = (Integer)Collections.min(propInt.func_177700_c());
        if (minAge == (maxAge = ((Integer)Collections.max(propInt.func_177700_c())).intValue()) || currentAge < maxAge) {
            return false;
        }
        Item seed = null;
        if (blockState.func_177230_c() instanceof CropsBlock && !(defaultSeedDrop = (crop = (CropsBlock)blockState.func_177230_c()).func_185473_a((IBlockReader)world, posCurrent, blockState)).func_190926_b()) {
            seed = defaultSeedDrop.func_77973_b();
        }
        List drops = Block.func_220070_a((BlockState)blockState, (ServerWorld)((ServerWorld)world), (BlockPos)posCurrent, null);
        for (ItemStack dropStack : drops) {
            if (seed != null && dropStack.func_77973_b() == seed) {
                dropStack.func_190918_g(1);
                seed = null;
            }
            UtilWorld.dropItemStackInWorld(world, posCurrent, dropStack);
        }
        if (world instanceof ServerWorld) {
            blockState.func_215706_a((ServerWorld)world, posCurrent, ItemStack.field_190927_a);
        }
        return (updated = world.func_175656_a(posCurrent, newState = (BlockState)blockState.func_206870_a((Property)propInt, (Comparable)Integer.valueOf(minAge)))) || drops.size() > 0;
    }

    private static boolean simpleBreakDrop(BlockState blockState) {
        boolean breakit = blockState.func_235714_a_(DataTags.VINES) || blockState.func_235714_a_(DataTags.CROP_BLOCKS);
        return breakit;
    }

    public static IntegerProperty getAgeProp(BlockState blockState) {
        if (blockState.func_177230_c() instanceof CropsBlock) {
            CropsBlock crops = (CropsBlock)blockState.func_177230_c();
            return crops.func_185524_e();
        }
        String age = CropsBlock.field_176488_a.func_177701_a();
        ResourceLocation bid = blockState.func_177230_c().getRegistryName();
        if ("resynth".equalsIgnoreCase(bid.func_110624_b())) {
            age = "growth_stage";
        }
        for (Property p : blockState.func_235904_r_()) {
            if (p == null || p.func_177701_a() == null || !(p instanceof IntegerProperty) || !p.func_177701_a().equalsIgnoreCase(age)) continue;
            return (IntegerProperty)p;
        }
        return null;
    }
}

