/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.config.ConfigRegistry;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PeatItem
extends ItemBase {
    public final PeatItemType type;

    public PeatItem(Item.Properties properties, PeatItemType t) {
        super(properties);
        this.type = t;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new StringTextComponent(this.getPeatFuelValue() + "RF/t for " + 40 + " ticks").func_240699_a_(TextFormatting.DARK_GREEN));
    }

    public int getPeatFuelValue() {
        switch (this.type) {
            case BIOMASS: {
                return 10;
            }
            case NORM: {
                return (Integer)ConfigRegistry.PEATPOWER.get();
            }
            case ENRICHED: {
                return (Integer)ConfigRegistry.PEATERICHPOWER.get();
            }
        }
        return 0;
    }

    public static enum PeatItemType {
        BIOMASS,
        NORM,
        ENRICHED;

    }
}

