/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.util.UtilParticle;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class WaterCandleBlock
extends BlockBase {
    private static int TICK_RATE = 50;
    private static int RADIUS = 5;
    private static double CHANCE_OFF = 0.02;
    private EntityClassification type = EntityClassification.MONSTER;
    private static final double BOUNDS = 3.0;
    private static final VoxelShape AABB = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private static final double CHANCE_SOUND = 0.3;

    public WaterCandleBlock(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.8f).func_226896_b_().func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && player.func_184586_b(hand).func_77973_b() == Items.field_151033_d) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)));
            UtilSound.playSound(world, pos, SoundEvents.field_187643_bs);
            return ActionResultType.SUCCESS;
        }
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && player.func_184586_b(hand).func_190926_b()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
            UtilSound.playSound(world, pos, SoundEvents.field_187646_bt);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue() && rand.nextDouble() < 0.3) {
            UtilSound.playSound(worldIn, pos, SoundEvents.field_187643_bs);
        }
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.triggerUpdate((World)worldIn, pos, rand);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.triggerUpdate((World)worldIn, pos, random);
    }

    private void triggerUpdate(World world, BlockPos pos, Random rand) {
        try {
            if (!world.field_72995_K && ((Boolean)world.func_180495_p(pos).func_177229_b((Property)LIT)).booleanValue()) {
                this.trySpawn(world, pos, rand);
            }
        }
        catch (Exception exception) {
            ModCyclic.LOGGER.error("Error spawning monster ", exception);
        }
    }

    private void trySpawn(World world, BlockPos pos, Random rand) throws Exception {
        float z;
        float y;
        float x = pos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)(-1 * RADIUS), (int)RADIUS);
        BlockPos posTarget = new BlockPos((double)x, (double)(y = (float)pos.func_177956_o()), (double)(z = (float)(pos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)(-1 * RADIUS), (int)RADIUS))));
        MobEntity monster = this.findMonsterToSpawn(world, posTarget, rand);
        if (monster == null || !world.func_175623_d(posTarget)) {
            return;
        }
        monster.func_70012_b((double)x, (double)y, (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((MobEntity)monster, (IWorld)world, (double)x, (double)y, (double)z, null, (SpawnReason)SpawnReason.SPAWNER);
        if (canSpawn == Event.Result.DENY || !monster.func_213380_a((IWorld)world, SpawnReason.SPAWNER)) {
            this.afterSpawnFailure(world, pos);
        } else if (world.func_217376_c((Entity)monster)) {
            this.afterSpawnSuccess(monster, world, pos, rand);
        }
    }

    private void afterSpawnFailure(World world, BlockPos pos) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, TICK_RATE);
    }

    private void afterSpawnSuccess(MobEntity monster, World world, BlockPos pos, Random rand) {
        monster.func_213386_a((IServerWorld)world.func_73046_m().func_71218_a(world.func_234923_W_()), world.func_175649_E(pos), SpawnReason.SPAWNER, null, null);
        if (rand.nextDouble() < CHANCE_OFF) {
            this.turnOff(world, pos);
        } else {
            world.func_205220_G_().func_205360_a(pos, (Object)this, TICK_RATE);
        }
    }

    private void turnOff(World world, BlockPos pos) {
        UtilSound.playSound(world, pos, SoundEvents.field_187646_bt);
        UtilParticle.spawnParticle(world, (IParticleData)ParticleTypes.field_218422_X, pos, 12);
        UtilParticle.spawnParticle(world, (IParticleData)ParticleTypes.field_218422_X, pos.func_177984_a(), 12);
        world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    private MobEntity findMonsterToSpawn(World world, BlockPos pos, Random rand) {
        List spawners = world.func_226691_t_(pos).func_242433_b().func_242559_a(this.type);
        if (spawners.isEmpty()) {
            return null;
        }
        MobSpawnInfo.Spawners spawner = (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)rand, (List)spawners);
        MobEntity monster = null;
        Entity ent = spawner.field_242588_c.func_200721_a(world);
        if (ent instanceof MobEntity) {
            monster = (MobEntity)ent;
        }
        return monster;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.func_177229_b((Property)LIT)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }
}

