/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.util.UtilBlockstates;
import com.lothrazar.cyclic.util.UtilSound;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FireplaceBlock
extends BlockBase {
    public FireplaceBlock(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.8f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isPowered = worldIn.func_175640_z(pos);
        BlockPos posFire = pos.func_177972_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H));
        if (worldIn.func_180495_p(posFire).func_200132_m()) {
            posFire = posFire.func_177984_a();
        }
        if (isPowered && !((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            if (this.setFire(worldIn, posFire, false) && worldIn.field_72995_K) {
                UtilSound.playSound(worldIn, pos, SoundEvents.field_187649_bu);
            }
        } else if (!isPowered && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && this.setFire(worldIn, posFire, true)) {
            worldIn.func_217379_c(1009, pos, 0);
        }
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(isPowered)));
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    private boolean setFire(World worldIn, BlockPos pos, boolean extinguish) {
        if (extinguish && this.canExtinguish(worldIn, pos)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (extinguish && this.canExtinguishInfiniteFire(worldIn, pos)) {
            worldIn.func_175656_a(pos.func_177972_a(Direction.UP), Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (!extinguish && this.canSetFire(worldIn, pos)) {
            worldIn.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            return true;
        }
        if (!extinguish && this.canSetInfiniteFire(worldIn, pos)) {
            worldIn.func_175656_a(pos.func_177972_a(Direction.UP), Blocks.field_150480_ab.func_176223_P());
            return true;
        }
        return false;
    }

    private boolean canSetFire(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) && worldIn.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_200132_m();
    }

    private boolean canSetInfiniteFire(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos.func_177972_a(Direction.UP)) && this.hasInfiniburnTag(worldIn, pos);
    }

    private boolean canExtinguish(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab;
    }

    private boolean canExtinguishInfiniteFire(World worldIn, BlockPos pos) {
        return this.hasInfiniburnTag(worldIn, pos) && this.canExtinguish(worldIn, pos.func_177972_a(Direction.UP));
    }

    private boolean hasInfiniburnTag(World worldIn, BlockPos pos) {
        return BlockTags.field_241279_aE_.func_230235_a_((Object)worldIn.func_180495_p(pos).func_177230_c()) && worldIn.func_234923_W_() == World.field_234920_i_ || BlockTags.field_241278_aD_.func_230235_a_((Object)worldIn.func_180495_p(pos).func_177230_c()) && worldIn.func_234923_W_() == World.field_234919_h_ || BlockTags.field_241277_aC_.func_230235_a_((Object)worldIn.func_180495_p(pos).func_177230_c()) && worldIn.func_234923_W_() == World.field_234918_g_;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)UtilBlockstates.getFacingFromEntity(pos, entity)), 2);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H}).func_206894_a(new Property[]{LIT});
    }
}

