/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ItemInfo;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemInfoHelper {
    public static Map<Enchantment, Integer> getEnchantments(ItemInfo info) {
        CompoundNBT tag = info.getNBT();
        if (tag == null) {
            return Collections.emptyMap();
        }
        String location = ItemInfoHelper.getEnchantTagLocation(info);
        if (!tag.func_150297_b(location, 9)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Enchantment, Integer> map = new LinkedHashMap<Enchantment, Integer>();
        ListNBT enchantments = tag.func_150295_c(location, 10);
        for (int i = 0; i < enchantments.size(); ++i) {
            Enchantment enchantment;
            CompoundNBT enchantNBT = enchantments.func_150305_b(i);
            ResourceLocation enchantmentID = ResourceLocation.func_208304_a((String)enchantNBT.func_74779_i("id"));
            if (enchantmentID == null || (enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantmentID)) == null) continue;
            map.put(enchantment, enchantNBT.func_74762_e("lvl"));
        }
        return map;
    }

    public static String getEnchantTagLocation(@Nonnull ItemInfo info) {
        return info.getItem() == Items.field_151134_bR ? "StoredEnchantments" : "Enchantments";
    }

    public static ItemInfo makeWithPotion(ItemInfo info, Potion potion) {
        CompoundNBT nbt = info.getNBT();
        if (potion == Potions.field_185229_a) {
            if (nbt != null && nbt.func_74764_b("Potion")) {
                nbt.func_82580_o("Potion");
                if (nbt.isEmpty()) {
                    nbt = null;
                }
            }
        } else {
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            nbt.func_74778_a("Potion", potion.getRegistryName().toString());
        }
        return ItemInfo.fromItem(info.getItem(), nbt);
    }
}

