/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_server;

import java.util.Optional;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.gameObjs.items.armor.GemChest;
import moze_intel.projecte.gameObjs.items.armor.GemFeet;
import moze_intel.projecte.gameObjs.items.armor.GemHelmet;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.fml.network.NetworkEvent;

public class KeyPressPKT
implements IPEPacket {
    private final PEKeybind key;

    public KeyPressPKT(PEKeybind key) {
        this.key = key;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        if (this.key == PEKeybind.HELMET_TOGGLE) {
            ItemStack helm = player.func_184582_a(EquipmentSlotType.HEAD);
            if (!helm.func_190926_b() && helm.func_77973_b() instanceof GemHelmet) {
                GemHelmet.toggleNightVision(helm, (PlayerEntity)player);
            }
            return;
        }
        if (this.key == PEKeybind.BOOTS_TOGGLE) {
            ItemStack boots = player.func_184582_a(EquipmentSlotType.FEET);
            if (!boots.func_190926_b() && boots.func_77973_b() instanceof GemFeet) {
                ((GemFeet)boots.func_77973_b()).toggleStepAssist(boots, (PlayerEntity)player);
            }
            return;
        }
        Optional cap = player.getCapability(InternalAbilities.CAPABILITY).resolve();
        if (!cap.isPresent()) {
            return;
        }
        InternalAbilities internalAbilities = (InternalAbilities)cap.get();
        block6: for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            switch (this.key) {
                case CHARGE: {
                    if (KeyPressPKT.tryPerformCapability(stack, ProjectEAPI.CHARGE_ITEM_CAPABILITY, capability -> capability.changeCharge((PlayerEntity)player, stack, hand))) {
                        return;
                    }
                    if (hand != Hand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !GemArmorBase.hasAnyPiece((PlayerEntity)player)) continue block6;
                    internalAbilities.setGemState(!internalAbilities.getGemState());
                    PELang langEntry = internalAbilities.getGemState() ? PELang.GEM_ACTIVATE : PELang.GEM_DEACTIVATE;
                    player.func_145747_a((ITextComponent)langEntry.translate(new Object[0]), Util.field_240973_b_);
                    return;
                }
                case EXTRA_FUNCTION: {
                    ItemStack chestplate;
                    if (KeyPressPKT.tryPerformCapability(stack, ProjectEAPI.EXTRA_FUNCTION_ITEM_CAPABILITY, capability -> capability.doExtraFunction(stack, (PlayerEntity)player, hand))) {
                        return;
                    }
                    if (hand != Hand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !internalAbilities.getGemState() || (chestplate = player.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b() || !(chestplate.func_77973_b() instanceof GemChest) || internalAbilities.getGemCooldown() != 0) continue block6;
                    ((GemChest)chestplate.func_77973_b()).doExplode((PlayerEntity)player);
                    internalAbilities.resetGemCooldown();
                    return;
                }
                case FIRE_PROJECTILE: {
                    ItemStack helmet;
                    if (!stack.func_190926_b() && internalAbilities.getProjectileCooldown() == 0 && KeyPressPKT.tryPerformCapability(stack, ProjectEAPI.PROJECTILE_SHOOTER_ITEM_CAPABILITY, capability -> capability.shootProjectile((PlayerEntity)player, stack, hand))) {
                        PlayerHelper.swingItem((PlayerEntity)player, hand);
                        internalAbilities.resetProjectileCooldown();
                    }
                    if (hand != Hand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !internalAbilities.getGemState() || (helmet = player.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() || !(helmet.func_77973_b() instanceof GemHelmet)) continue block6;
                    ((GemHelmet)helmet.func_77973_b()).doZap((PlayerEntity)player);
                    return;
                }
                case MODE: {
                    if (!KeyPressPKT.tryPerformCapability(stack, ProjectEAPI.MODE_CHANGER_ITEM_CAPABILITY, capability -> capability.changeMode((PlayerEntity)player, stack, hand))) continue block6;
                    return;
                }
            }
        }
    }

    private static <CAPABILITY> boolean tryPerformCapability(ItemStack stack, Capability<CAPABILITY> capability, NonNullPredicate<CAPABILITY> perform) {
        return !stack.func_190926_b() && stack.getCapability(capability).filter(perform).isPresent();
    }

    private static boolean isSafe(ItemStack stack) {
        return ProjectEConfig.server.misc.unsafeKeyBinds.get() || stack.func_190926_b();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.key);
    }

    public static KeyPressPKT decode(PacketBuffer buf) {
        return new KeyPressPKT((PEKeybind)buf.func_179257_a(PEKeybind.class));
    }
}

