/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import moze_intel.projecte.PECore;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

@Mod.EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class ThreadCheckUpdate
extends Thread {
    private static final String curseURL = "https://www.curseforge.com/minecraft/mc-mods/projecte/files";
    private static volatile ComparableVersion target = null;
    private static volatile boolean hasSentMessage = false;

    public ThreadCheckUpdate() {
        this.setName("ProjectE Update Checker Notifier");
    }

    @Override
    public void run() {
        if (!FMLConfig.runVersionCheck()) {
            return;
        }
        IModInfo info = PECore.MOD_CONTAINER.getModInfo();
        VersionChecker.CheckResult result = null;
        int tries = 0;
        do {
            VersionChecker.CheckResult res = VersionChecker.getResult((IModInfo)info);
            if (res.status != VersionChecker.Status.PENDING) {
                result = res;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (result == null && ++tries < 10);
        if (result == null) {
            PECore.LOGGER.info("Update check failed.");
            return;
        }
        if (result.status == VersionChecker.Status.OUTDATED) {
            target = result.target;
        }
    }

    @SubscribeEvent
    public static void worldLoad(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof ClientPlayerEntity && target != null && !hasSentMessage) {
            hasSentMessage = true;
            evt.getEntity().func_145747_a((ITextComponent)PELang.UPDATE_AVAILABLE.translate(target), Util.field_240973_b_);
            evt.getEntity().func_145747_a((ITextComponent)PELang.UPDATE_GET_IT.translate(new Object[0]), Util.field_240973_b_);
            StringTextComponent link = new StringTextComponent(curseURL);
            link.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, curseURL));
            evt.getEntity().func_145747_a((ITextComponent)link, Util.field_240973_b_);
        }
    }
}

