/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.api.tile.TileEmcBase;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEmc
extends TileEmcBase
implements ITickableTileEntity {
    private boolean updateComparators;

    public TileEmc(TileEntityType<?> type) {
        this(type, Long.MAX_VALUE);
    }

    public TileEmc(TileEntityType<?> type, long maxAmount) {
        super(type);
        this.setMaximumEMC(maxAmount);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.updateComparators) {
            BlockState state = this.func_195044_w();
            if (!state.isAir((IBlockReader)this.field_145850_b, this.field_174879_c)) {
                this.field_145850_b.func_175666_e(this.field_174879_c, state.func_177230_c());
            }
            this.updateComparators = false;
        }
    }

    protected boolean emcAffectsComparators() {
        return false;
    }

    @Override
    protected void storedEmcChanged() {
        this.markDirty(false, this.emcAffectsComparators());
    }

    public void func_70296_d() {
        this.markDirty(true, true);
    }

    public void markDirty(boolean recheckBlockState, boolean recheckComparators) {
        if (this.field_145850_b != null) {
            if (recheckBlockState) {
                this.func_145836_u();
            }
            if (this.field_145850_b.func_175667_e(this.field_174879_c)) {
                this.field_145850_b.func_175726_f(this.field_174879_c).func_76630_e();
            }
            if (recheckComparators && !this.field_145850_b.field_72995_K) {
                this.updateComparators = true;
            }
        }
    }

    @Nonnull
    public final CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    protected long sendToAllAcceptors(long emc) {
        if (this.field_145850_b == null || !this.canProvideEmc()) {
            return 0L;
        }
        emc = Math.min(this.getEmcExtractLimit(), emc);
        long sentEmc = 0L;
        ArrayList targets = new ArrayList();
        for (Direction dir : Direction.values()) {
            TileEntity neighboringTile;
            BlockPos neighboringPos = this.field_174879_c.func_177972_a(dir);
            if (!this.field_145850_b.func_195588_v(neighboringPos) || (neighboringTile = WorldHelper.getTileEntity((IBlockReader)this.field_145850_b, neighboringPos)) == null) continue;
            neighboringTile.getCapability(ProjectEAPI.EMC_STORAGE_CAPABILITY, dir.func_176734_d()).ifPresent(theirEmcStorage -> {
                if (!(this.isRelay() && theirEmcStorage.isRelay() || theirEmcStorage.insertEmc(1L, IEmcStorage.EmcAction.SIMULATE) <= 0L)) {
                    targets.add(theirEmcStorage);
                }
            });
        }
        if (!targets.isEmpty()) {
            long emcPer = emc / (long)targets.size();
            for (IEmcStorage target : targets) {
                long emcCanProvide = this.extractEmc(emcPer, IEmcStorage.EmcAction.SIMULATE);
                long acceptedEmc = target.insertEmc(emcCanProvide, IEmcStorage.EmcAction.EXECUTE);
                this.extractEmc(acceptedEmc, IEmcStorage.EmcAction.EXECUTE);
                sentEmc += acceptedEmc;
            }
        }
        return sentEmc;
    }

    class CompactableStackHandler
    extends StackHandler {
        private boolean needsCompacting;
        private boolean empty;

        CompactableStackHandler(int size) {
            super(size);
            this.needsCompacting = true;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.needsCompacting = true;
        }

        public void compact() {
            if (this.needsCompacting) {
                if (TileEmc.this.field_145850_b != null && !((TileEmc)TileEmc.this).field_145850_b.field_72995_K) {
                    this.empty = ItemHelper.compactInventory((IItemHandlerModifiable)this);
                }
                this.needsCompacting = false;
            }
        }

        protected void onLoad() {
            super.onLoad();
            this.empty = IntStream.range(0, this.getSlots()).allMatch(slot -> this.getStackInSlot(slot).func_190926_b());
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }

    class StackHandler
    extends ItemStackHandler {
        StackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEmc.this.markDirty(false, true);
        }
    }
}

