/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import moze_intel.projecte.capability.managing.SidedItemHandlerResolver;
import moze_intel.projecte.gameObjs.blocks.MatterFurnace;
import moze_intel.projecte.gameObjs.container.DMFurnaceContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registries.PETileEntityTypes;
import moze_intel.projecte.gameObjs.tiles.CapabilityTileEMC;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.DropperTileEntity;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class DMFurnaceTile
extends CapabilityTileEMC
implements INamedContainerProvider {
    private static final long EMC_CONSUMPTION = 2L;
    private final TileEmc.CompactableStackHandler inputInventory = new TileEmc.CompactableStackHandler(this, this.getInvSize());
    private final TileEmc.CompactableStackHandler outputInventory = new TileEmc.CompactableStackHandler(this, this.getInvSize());
    private final ItemStackHandler fuelInv = new TileEmc.StackHandler(this, 1);
    protected final int ticksBeforeSmelt;
    private final int efficiencyBonus;
    private final FurnaceTileEntity dummyFurnace = new FurnaceTileEntity();
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;

    public DMFurnaceTile() {
        this((TileEntityType)PETileEntityTypes.DARK_MATTER_FURNACE.get(), 10, 3);
    }

    protected DMFurnaceTile(TileEntityType<?> type, int ticksBeforeSmelt, int efficiencyBonus) {
        super(type, 64L);
        this.ticksBeforeSmelt = ticksBeforeSmelt;
        this.efficiencyBonus = efficiencyBonus;
        this.itemHandlerResolver = new DMFurnaceItemHandlerProvider();
    }

    @Override
    protected boolean canProvideEmc() {
        return false;
    }

    @Override
    protected long getEmcInsertLimit() {
        return 2L;
    }

    protected int getInvSize() {
        return 9;
    }

    protected float getOreDoubleChance() {
        return 0.5f;
    }

    public int getCookProgressScaled(int value) {
        return this.furnaceCookTime * value / this.ticksBeforeSmelt;
    }

    @Nonnull
    public Container createMenu(int windowId, @Nonnull PlayerInventory playerInv, @Nonnull PlayerEntity playerIn) {
        return new DMFurnaceContainer(windowId, playerInv, this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return PELang.GUI_DARK_MATTER_FURNACE.translate(new Object[0]);
    }

    public void func_174878_a(@Nonnull BlockPos pos) {
        super.func_174878_a(pos);
        this.dummyFurnace.func_174878_a(pos);
    }

    public void func_226984_a_(@Nonnull World world, @Nonnull BlockPos pos) {
        super.func_226984_a_(world, pos);
        this.dummyFurnace.func_226984_a_(world, pos);
    }

    public IItemHandler getFuel() {
        return this.fuelInv;
    }

    private ItemStack getFuelItem() {
        return this.fuelInv.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.inputInventory;
    }

    public IItemHandler getOutput() {
        return this.outputInventory;
    }

    @Override
    public void func_73660_a() {
        boolean wasBurning = this.isBurning();
        int lastFurnaceBurnTime = this.furnaceBurnTime--;
        int lastFurnaceCookTime = this.furnaceCookTime;
        if (this.isBurning()) {
            // empty if block
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.inputInventory.compact();
            this.outputInventory.compact();
            this.pullFromInventories();
            ItemStack fuelItem = this.getFuelItem();
            if (this.canSmelt() && !fuelItem.func_190926_b()) {
                fuelItem.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).ifPresent(emcHolder -> {
                    long simulatedExtraction = emcHolder.extractEmc(fuelItem, 2L, IEmcStorage.EmcAction.SIMULATE);
                    if (simulatedExtraction == 2L) {
                        this.forceInsertEmc(emcHolder.extractEmc(fuelItem, simulatedExtraction, IEmcStorage.EmcAction.EXECUTE), IEmcStorage.EmcAction.EXECUTE);
                    }
                    this.markDirty(false, false);
                });
            }
            if (this.getStoredEmc() >= 2L) {
                this.furnaceBurnTime = 1;
                this.forceExtractEmc(2L, IEmcStorage.EmcAction.EXECUTE);
            }
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(fuelItem);
                if (this.isBurning() && !fuelItem.func_190926_b()) {
                    ItemStack copy = fuelItem.func_77946_l();
                    fuelItem.func_190918_g(1);
                    if (fuelItem.func_190926_b()) {
                        this.fuelInv.setStackInSlot(0, copy.func_77973_b().getContainerItem(copy));
                    }
                    this.markDirty(false, false);
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.ticksBeforeSmelt) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                }
            }
            if (wasBurning != this.isBurning()) {
                BlockState state = this.func_195044_w();
                if (state.func_177230_c() instanceof MatterFurnace) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)MatterFurnace.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())));
                }
                this.func_70296_d();
            }
            this.pushToInventories();
        }
        if (lastFurnaceBurnTime != this.furnaceBurnTime || lastFurnaceCookTime != this.furnaceCookTime) {
            this.markDirty(false, false);
        }
        super.func_73660_a();
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private void pullFromInventories() {
        TileEntity tile = WorldHelper.getTileEntity((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a());
        if (tile == null || tile instanceof HopperTileEntity || tile instanceof DropperTileEntity) {
            return;
        }
        IItemHandler handler = WorldHelper.getItemHandler(tile, Direction.DOWN);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractTest = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (extractTest.func_190926_b()) continue;
            ItemStackHandler targetInv = AbstractFurnaceTileEntity.func_213991_b((ItemStack)extractTest) || extractTest.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).isPresent() ? this.fuelInv : this.inputInventory;
            this.transferItem((IItemHandler)targetInv, i, extractTest, handler);
        }
    }

    private void pushToInventories() {
        if (this.outputInventory.isEmpty()) {
            return;
        }
        TileEntity tile = WorldHelper.getTileEntity((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b());
        if (tile == null || tile instanceof HopperTileEntity) {
            return;
        }
        IItemHandler targetInv = WorldHelper.getItemHandler(tile, Direction.UP);
        if (targetInv == null) {
            return;
        }
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack extractTest = this.outputInventory.extractItem(i, Integer.MAX_VALUE, true);
            if (extractTest.func_190926_b()) continue;
            this.transferItem(targetInv, i, extractTest, (IItemHandler)this.outputInventory);
        }
    }

    private void transferItem(IItemHandler targetInv, int i, ItemStack extractTest, IItemHandler outputInventory) {
        ItemStack remainderTest = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)extractTest, (boolean)true);
        int successfullyTransferred = extractTest.func_190916_E() - remainderTest.func_190916_E();
        if (successfullyTransferred > 0) {
            ItemStack toInsert = outputInventory.extractItem(i, successfullyTransferred, false);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)toInsert, (boolean)false);
            assert (result.func_190926_b());
        }
    }

    public ItemStack getSmeltingResult(ItemStack in) {
        this.dummyFurnace.func_70299_a(0, in);
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this.dummyFurnace, this.field_145850_b);
        this.dummyFurnace.func_174888_l();
        return recipe.map(IRecipe::func_77571_b).orElse(ItemStack.field_190927_a);
    }

    private void smeltItem() {
        ItemStack toSmelt = this.inputInventory.getStackInSlot(0);
        ItemStack smeltResult = this.getSmeltingResult(toSmelt).func_77946_l();
        if (this.field_145850_b != null && this.field_145850_b.field_73012_v.nextFloat() < this.getOreDoubleChance() && ItemHelper.isOre(toSmelt.func_77973_b())) {
            smeltResult.func_190917_f(smeltResult.func_190916_E());
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)smeltResult, (boolean)false);
        toSmelt.func_190918_g(1);
    }

    protected boolean canSmelt() {
        ItemStack toSmelt = this.inputInventory.getStackInSlot(0);
        if (toSmelt.func_190926_b()) {
            return false;
        }
        ItemStack smeltResult = this.getSmeltingResult(toSmelt);
        if (smeltResult.func_190926_b()) {
            return false;
        }
        ItemStack currentSmelted = this.outputInventory.getStackInSlot(this.outputInventory.getSlots() - 1);
        if (currentSmelted.func_190926_b()) {
            return true;
        }
        if (!smeltResult.func_77969_a(currentSmelted)) {
            return false;
        }
        int result = currentSmelted.func_190916_E() + smeltResult.func_190916_E();
        return result <= currentSmelted.func_77976_d();
    }

    private int getItemBurnTime(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (IRecipeType)IRecipeType.field_222150_b) * this.ticksBeforeSmelt / 200 * this.efficiencyBonus;
    }

    public int getBurnTimeRemainingScaled(int value) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.ticksBeforeSmelt;
        }
        return this.furnaceBurnTime * value / this.currentItemBurnTime;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.furnaceBurnTime = nbt.func_74762_e("BurnTime");
        this.furnaceCookTime = nbt.func_74762_e("CookTime");
        this.inputInventory.deserializeNBT(nbt.func_74775_l("Input"));
        this.outputInventory.deserializeNBT(nbt.func_74775_l("Output"));
        this.fuelInv.deserializeNBT(nbt.func_74775_l("Fuel"));
        this.currentItemBurnTime = this.getItemBurnTime(this.getFuelItem());
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74768_a("BurnTime", this.furnaceBurnTime);
        nbt.func_74768_a("CookTime", this.furnaceCookTime);
        nbt.func_218657_a("Input", (INBT)this.inputInventory.serializeNBT());
        nbt.func_218657_a("Output", (INBT)this.outputInventory.serializeNBT());
        nbt.func_218657_a("Fuel", (INBT)this.fuelInv.serializeNBT());
        return nbt;
    }

    private class DMFurnaceItemHandlerProvider
    extends SidedItemHandlerResolver {
        private final ICapabilityResolver<IItemHandler> joined;
        private final ICapabilityResolver<IItemHandler> automationInput;
        private final ICapabilityResolver<IItemHandler> automationOutput;
        private final ICapabilityResolver<IItemHandler> automationSides;

        protected DMFurnaceItemHandlerProvider() {
            NonNullLazy automationInput = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)DMFurnaceTile.this.inputInventory, WrappedItemHandler.WriteMode.IN){

                @Override
                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    return !DMFurnaceTile.this.getSmeltingResult(stack).func_190926_b() ? super.insertItem(slot, stack, simulate) : stack;
                }
            });
            NonNullLazy automationFuel = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)DMFurnaceTile.this.fuelInv, WrappedItemHandler.WriteMode.IN){

                @Override
                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    return SlotPredicates.FURNACE_FUEL.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
                }
            });
            NonNullLazy automationOutput = NonNullLazy.of(() -> new WrappedItemHandler((IItemHandlerModifiable)DMFurnaceTile.this.outputInventory, WrappedItemHandler.WriteMode.OUT));
            this.joined = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)automationInput.get(), (IItemHandlerModifiable)automationFuel.get(), (IItemHandlerModifiable)automationOutput.get()})));
            this.automationInput = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)automationInput);
            this.automationOutput = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)automationOutput);
            this.automationSides = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)((NonNullSupplier)() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)automationFuel.get(), (IItemHandlerModifiable)automationOutput.get()})));
        }

        @Override
        protected ICapabilityResolver<IItemHandler> getResolver(@Nullable Direction side) {
            if (side == null) {
                return this.joined;
            }
            if (side == Direction.UP) {
                return this.automationInput;
            }
            if (side == Direction.DOWN) {
                return this.automationOutput;
            }
            return this.automationSides;
        }

        @Override
        public void invalidateAll() {
            this.joined.invalidateAll();
            this.automationInput.invalidateAll();
            this.automationOutput.invalidateAll();
            this.automationSides.invalidateAll();
        }
    }
}

