/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.registration.impl;

import moze_intel.projecte.gameObjs.registration.INamedEntry;
import moze_intel.projecte.gameObjs.registration.WrappedDeferredRegister;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class ContainerTypeDeferredRegister
extends WrappedDeferredRegister<ContainerType<?>> {
    public ContainerTypeDeferredRegister() {
        super(ForgeRegistries.CONTAINERS);
    }

    public <CONTAINER extends Container, TILE extends TileEntity> ContainerTypeRegistryObject<CONTAINER> register(INamedEntry nameProvider, Class<TILE> tileClass, ITileContainerFactory<CONTAINER, TILE> factory) {
        return this.register(nameProvider, (id, inv, buf) -> factory.create(id, inv, ContainerTypeDeferredRegister.getTeFromBuf(buf, tileClass)));
    }

    public <CONTAINER extends Container> ContainerTypeRegistryObject<CONTAINER> register(INamedEntry nameProvider, IContainerFactory<CONTAINER> factory) {
        return this.register(nameProvider.getInternalRegistryName(), factory);
    }

    public <CONTAINER extends Container> ContainerTypeRegistryObject<CONTAINER> register(String name, IContainerFactory<CONTAINER> factory) {
        return this.register(name, () -> IForgeContainerType.create((IContainerFactory)factory), ContainerTypeRegistryObject::new);
    }

    private static <TILE extends TileEntity> TILE getTeFromBuf(PacketBuffer buf, Class<TILE> type) {
        if (buf == null) {
            throw new IllegalArgumentException("Null packet buffer");
        }
        return (TILE)((TileEntity)DistExecutor.unsafeRunForDist(() -> () -> {
            BlockPos pos = buf.func_179259_c();
            Object tile = WorldHelper.getTileEntity(type, (IBlockReader)Minecraft.func_71410_x().field_71441_e, pos);
            if (tile == null) {
                throw new IllegalStateException("Client could not locate tile at " + pos + " for tile container. This is likely caused by a mod breaking client side tile lookup");
            }
            return tile;
        }, () -> () -> {
            throw new RuntimeException("Shouldn't be called on server!");
        }));
    }

    public static interface ITileContainerFactory<CONTAINER extends Container, TILE extends TileEntity> {
        public CONTAINER create(int var1, PlayerInventory var2, TILE var3);
    }
}

