/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SoulStone
extends PEToggleItem
implements IPedestalItem {
    public SoulStone(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slot, boolean held) {
        if (world.field_72995_K || slot >= PlayerInventory.func_70451_h() || !(entity instanceof PlayerEntity)) {
            return;
        }
        super.func_77663_a(stack, world, entity, slot, held);
        PlayerEntity player = (PlayerEntity)entity;
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n("Active")) {
            if (SoulStone.getEmc(stack) < 64L && !SoulStone.consumeFuel(player, stack, 64L, false)) {
                nbt.func_74757_a("Active", false);
            } else {
                player.getCapability(InternalTimers.CAPABILITY, null).ifPresent(timers -> {
                    timers.activateHeal();
                    if (player.func_110143_aJ() < player.func_110138_aP() && timers.canHeal()) {
                        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.HEAL.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player.func_70691_i(2.0f);
                        SoulStone.removeEmc(stack, 64L);
                    }
                });
            }
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.cooldown.pedestal.soul.get() != -1 && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            if (tile.getActivityCooldown() == 0) {
                List players = world.func_217357_a(ServerPlayerEntity.class, tile.getEffectBounds());
                for (ServerPlayerEntity player : players) {
                    if (!(player.func_110143_aJ() < player.func_110138_aP())) continue;
                    world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)PESoundEvents.HEAL.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    player.func_70691_i(1.0f);
                }
                tile.setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.soul.get());
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.cooldown.pedestal.soul.get() != -1) {
            list.add((ITextComponent)PELang.PEDESTAL_SOUL_STONE_1.translateColored(TextFormatting.BLUE, new Object[0]));
            list.add((ITextComponent)PELang.PEDESTAL_SOUL_STONE_2.translateColored(TextFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.soul.get())));
        }
        return list;
    }
}

