/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.capability.ModeChangerItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.IItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.NonNullLazy;

public class DiviningRod
extends ItemPE
implements IItemMode {
    private final ILangEntry[] modes;
    private final int maxModes;

    public DiviningRod(Item.Properties props, ILangEntry ... modeDesc) {
        super(props);
        this.modes = modeDesc;
        this.maxModes = this.modes.length;
        this.addItemCapability(ModeChangerItemCapabilityWrapper::new);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        World world = ctx.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        LongArrayList emcValues = new LongArrayList();
        long totalEmc = 0L;
        int numBlocks = 0;
        int depth = this.getDepthFromMode(ctx.func_195996_i());
        NonNullLazy furnaceRecipes = NonNullLazy.of(() -> world.func_199532_z().func_241447_a_(IRecipeType.field_222150_b));
        for (BlockPos digPos : WorldHelper.getPositionsFromBox(WorldHelper.getDeepBox(ctx.func_195995_a(), ctx.func_196000_l(), depth))) {
            BlockState state;
            List drops;
            if (world.func_175623_d(digPos) || (drops = Block.func_220077_a((BlockState)(state = world.func_180495_p(digPos)), (ServerWorld)((ServerWorld)world), (BlockPos)digPos, (TileEntity)WorldHelper.getTileEntity((IBlockReader)world, digPos), (Entity)player, (ItemStack)ctx.func_195996_i())).isEmpty()) continue;
            ItemStack blockStack = (ItemStack)drops.get(0);
            long blockEmc = EMCHelper.getEmcValue(blockStack);
            if (blockEmc == 0L) {
                for (FurnaceRecipe furnaceRecipe : (List)furnaceRecipes.get()) {
                    long currentValue;
                    if (!((Ingredient)furnaceRecipe.func_192400_c().get(0)).test(blockStack) || (currentValue = EMCHelper.getEmcValue(furnaceRecipe.func_77571_b())) == 0L) continue;
                    if (!emcValues.contains(currentValue)) {
                        emcValues.add(currentValue);
                    }
                    totalEmc += currentValue;
                    break;
                }
            } else {
                if (!emcValues.contains(blockEmc)) {
                    emcValues.add(blockEmc);
                }
                totalEmc += blockEmc;
            }
            ++numBlocks;
        }
        if (numBlocks == 0) {
            return ActionResultType.FAIL;
        }
        player.func_145747_a((ITextComponent)PELang.DIVINING_AVG_EMC.translate(numBlocks, totalEmc / (long)numBlocks), Util.field_240973_b_);
        if (this == PEItems.MEDIUM_DIVINING_ROD.get() || this == PEItems.HIGH_DIVINING_ROD.get()) {
            long[] maxValues = new long[3];
            for (int i = 0; i < 3; ++i) {
                maxValues[i] = 1L;
            }
            emcValues.sort(Comparator.reverseOrder());
            int num = Math.min(emcValues.size(), 3);
            for (int i = 0; i < num; ++i) {
                maxValues[i] = emcValues.getLong(i);
            }
            player.func_145747_a((ITextComponent)PELang.DIVINING_MAX_EMC.translate(maxValues[0]), Util.field_240973_b_);
            if (this == PEItems.HIGH_DIVINING_ROD.get()) {
                player.func_145747_a((ITextComponent)PELang.DIVINING_SECOND_MAX.translate(maxValues[1]), Util.field_240973_b_);
                player.func_145747_a((ITextComponent)PELang.DIVINING_THIRD_MAX.translate(maxValues[2]), Util.field_240973_b_);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private int getDepthFromMode(ItemStack stack) {
        byte mode = this.getMode(stack);
        if (mode < 0 || mode >= this.maxModes) {
            return 0;
        }
        if (mode == 0) {
            return 3;
        }
        if (mode == 1) {
            return 16;
        }
        return 64;
    }

    @Override
    public ILangEntry[] getModeLangEntries() {
        return this.modes;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add(this.getToolTip(stack));
    }
}

