/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.slots.transmutation;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.container.slots.InventoryContainerSlot;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SlotInput
extends InventoryContainerSlot {
    private final TransmutationInventory inv;

    public SlotInput(TransmutationInventory inv, int index, int x, int y) {
        super((IItemHandler)inv, index, x, y);
        this.inv = inv;
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return SlotPredicates.RELAY_INV.test(stack);
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        ItemStack stack = super.func_75209_a(amount);
        if (!stack.func_190926_b() && this.inv.isServer()) {
            this.inv.syncChangedSlots(Collections.singletonList(this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.IF_NEEDED);
        }
        return stack;
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        super.func_75215_d(stack);
        if (this.inv.isServer()) {
            if (stack.func_190926_b()) {
                this.inv.syncChangedSlots(Collections.singletonList(this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.ALL);
            } else {
                Optional capability;
                if (EMCHelper.doesItemHaveEmc(stack)) {
                    this.inv.handleKnowledge(stack);
                }
                if ((capability = stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve()).isPresent()) {
                    long shrunkenAvailableEMC;
                    IItemEmcHolder emcHolder = (IItemEmcHolder)capability.get();
                    long actualInserted = emcHolder.insertEmc(stack, shrunkenAvailableEMC = MathUtils.clampToLong(this.inv.provider.getEmc()), IEmcStorage.EmcAction.EXECUTE);
                    if (actualInserted > 0L) {
                        this.inv.syncChangedSlots(Collections.singletonList(this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.NONE);
                        this.inv.removeEmc(BigInteger.valueOf(actualInserted));
                    } else if (emcHolder.getStoredEmc(stack) > 0L) {
                        this.inv.syncChangedSlots(Collections.singletonList(this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.ALL);
                    } else {
                        this.inv.syncChangedSlots(Collections.singletonList(this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.NONE);
                    }
                } else {
                    this.inv.syncChangedSlots(Collections.singletonList(this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.NONE);
                }
            }
        }
    }

    public int func_75219_a() {
        return 1;
    }
}

