/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.blocks.Collector;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotGhost;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.items.IItemHandler;

public class CollectorMK1Container
extends PEContainer {
    public final CollectorMK1Tile tile;
    public final IntReferenceHolder sunLevel = IntReferenceHolder.func_221492_a();
    public final PEContainer.BoxedLong emc = new PEContainer.BoxedLong();
    private final IntReferenceHolder kleinChargeProgress = IntReferenceHolder.func_221492_a();
    private final IntReferenceHolder fuelProgress = IntReferenceHolder.func_221492_a();
    public final PEContainer.BoxedLong kleinEmc = new PEContainer.BoxedLong();

    public CollectorMK1Container(int windowId, PlayerInventory invPlayer, CollectorMK1Tile collector) {
        this(PEContainerTypes.COLLECTOR_MK1_CONTAINER, windowId, invPlayer, collector);
    }

    protected CollectorMK1Container(ContainerTypeRegistryObject<? extends CollectorMK1Container> type, int windowId, PlayerInventory invPlayer, CollectorMK1Tile collector) {
        super(type, windowId);
        this.longFields.add(this.emc);
        this.func_216958_a(this.sunLevel);
        this.func_216958_a(this.kleinChargeProgress);
        this.func_216958_a(this.fuelProgress);
        this.longFields.add(this.kleinEmc);
        this.tile = collector;
        this.initSlots(invPlayer);
    }

    void initSlots(PlayerInventory invPlayer) {
        IItemHandler aux = this.tile.getAux();
        IItemHandler main = this.tile.getInput();
        this.func_75146_a((Slot)new ValidatedSlot(aux, 0, 124, 58, SlotPredicates.COLLECTOR_INV));
        int counter = 0;
        for (int i = 1; i >= 0; --i) {
            for (int j = 3; j >= 0; --j) {
                this.func_75146_a((Slot)new ValidatedSlot(main, counter++, 20 + i * 18, 8 + j * 18, SlotPredicates.COLLECTOR_INV));
            }
        }
        this.func_75146_a((Slot)new ValidatedSlot(aux, 1, 124, 13, SlotPredicates.ALWAYS_FALSE));
        this.func_75146_a((Slot)new SlotGhost(aux, 2, 153, 36, SlotPredicates.COLLECTOR_LOCK));
        this.addPlayerInventory(invPlayer, 8, 84);
    }

    @Nonnull
    public ItemStack func_184996_a(int slotID, int button, @Nonnull ClickType flag, @Nonnull PlayerEntity player) {
        Slot slot = this.tryGetSlot(slotID);
        if (slot instanceof SlotGhost && !slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotID, button, flag, player);
    }

    @Override
    public void func_75142_b() {
        this.emc.set(this.tile.getStoredEmc());
        this.sunLevel.func_221494_a(this.tile.getSunLevel());
        this.kleinChargeProgress.func_221494_a((int)(this.tile.getItemChargeProportion() * 8000.0));
        this.fuelProgress.func_221494_a((int)(this.tile.getFuelProgress() * 8000.0));
        this.kleinEmc.set(this.tile.getItemCharge());
        super.func_75142_b();
    }

    protected BlockRegistryObject<Collector, ?> getValidBlock() {
        return PEBlocks.COLLECTOR;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return CollectorMK1Container.stillValid(player, this.tile, this.getValidBlock());
    }

    public double getKleinChargeProgress() {
        return (double)this.kleinChargeProgress.func_221495_b() / 8000.0;
    }

    public double getFuelProgress() {
        return (double)this.fuelProgress.func_221495_b() / 8000.0;
    }
}

