/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.gameObjs.EnumCollectorTier;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK3Tile;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Collector
extends BlockDirection {
    private final EnumCollectorTier tier;

    public Collector(EnumCollectorTier tier, AbstractBlock.Properties props) {
        super(props);
        this.tier = tier;
    }

    public EnumCollectorTier getTier() {
        return this.tier;
    }

    @Nonnull
    @Deprecated
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        CollectorMK1Tile te;
        if (!world.field_72995_K && (te = WorldHelper.getTileEntity(CollectorMK1Tile.class, (IBlockReader)world, pos, true)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)te, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    @Deprecated
    public INamedContainerProvider func_220052_b(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return WorldHelper.getTileEntity(CollectorMK1Tile.class, (IBlockReader)world, pos, true);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        switch (this.tier) {
            case MK1: {
                return new CollectorMK1Tile();
            }
            case MK2: {
                return new CollectorMK2Tile();
            }
            case MK3: {
                return new CollectorMK3Tile();
            }
        }
        return null;
    }

    @Deprecated
    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        CollectorMK1Tile tile = WorldHelper.getTileEntity(CollectorMK1Tile.class, (IBlockReader)world, pos, true);
        if (tile == null) {
            return super.func_180641_l(state, world, pos);
        }
        Optional cap = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).resolve();
        if (!cap.isPresent()) {
            return super.func_180641_l(state, world, pos);
        }
        ItemStack charging = ((IItemHandler)cap.get()).getStackInSlot(0);
        if (!charging.func_190926_b()) {
            Optional holderCapability = charging.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve();
            if (holderCapability.isPresent()) {
                IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
                return MathUtils.scaleToRedstone(emcHolder.getStoredEmc(charging), emcHolder.getMaximumEmc(charging));
            }
            return MathUtils.scaleToRedstone(tile.getStoredEmc(), tile.getEmcToNextGoal());
        }
        return MathUtils.scaleToRedstone(tile.getStoredEmc(), tile.getMaximumEmc());
    }

    @Override
    @Deprecated
    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            CollectorMK1Tile ent = WorldHelper.getTileEntity(CollectorMK1Tile.class, (IBlockReader)world, pos);
            if (ent != null) {
                ent.clearLocked();
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }
}

