/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.other.collision;

import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.skds.core.api.collision.IOBBEntity;
import net.skds.core.util.mat.Vec3;
import net.skds.core.util.other.collision.OBB;

public class OBBBody<E extends Entity> {
    public final E entity;
    private Vec3 motion = Vec3.ZERO;

    public OBBBody(E entity) {
        this.entity = entity;
    }

    public void tick() {
        this.motion = new Vec3(this.entity.func_213322_ci());
        AxisAlignedBB largeBox = this.entity.func_174813_aQ();
        for (OBB obb : ((IOBBEntity)this.entity).getBoxes()) {
            largeBox = largeBox.func_111270_a(obb.aabb);
        }
        Vec3 maxMove = this.getAllowedMovementV3(this.motion.getMojangD(), largeBox);
        if (maxMove.equals(this.motion)) {
            this.move(this.motion);
        }
    }

    private void setMotion() {
        this.entity.func_213317_d(this.motion.getMojangD());
    }

    private Vec3 getAllowedMovementV3(Vector3d vec, AxisAlignedBB axisalignedbb) {
        ISelectionContext iselectioncontext = ISelectionContext.func_216374_a(this.entity);
        VoxelShape voxelshape = ((Entity)this.entity).field_70170_p.func_175723_af().func_222521_a();
        Stream<Object> stream = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb), (IBooleanFunction)IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(voxelshape);
        ReuseableStream reuseablestream = new ReuseableStream(stream);
        Vector3d vector3d = vec.func_189985_c() == 0.0 ? vec : this.collideCustom(vec, axisalignedbb, ((Entity)this.entity).field_70170_p, iselectioncontext, (ReuseableStream<VoxelShape>)reuseablestream);
        return new Vec3(vector3d);
    }

    private Vector3d collideCustom(Vector3d vec, AxisAlignedBB collisionBox, World world, ISelectionContext context, ReuseableStream<VoxelShape> potentialHits) {
        Stream stream = world.func_226666_b_(this.entity, collisionBox.func_216361_a(vec));
        ReuseableStream reuseablestream = new ReuseableStream(Stream.concat(potentialHits.func_212761_a(), stream));
        return Entity.func_223310_a((Vector3d)vec, (AxisAlignedBB)collisionBox, (ReuseableStream)reuseablestream);
    }

    private void move(Vec3 move) {
        this.entity.func_70107_b(this.entity.func_226277_ct_() + move.x, this.entity.func_226278_cu_() + move.y, this.entity.func_226281_cx_() + move.z);
    }

    public static double approxAngle(double d) {
        double out = d % 360.0;
        if (out > 180.0) {
            out -= 360.0;
        } else if (out < -180.0) {
            out += 360.0;
        }
        return out;
    }
}

