/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.other.collision;

import net.minecraft.util.math.AxisAlignedBB;
import net.skds.core.util.mat.Matrix3;
import net.skds.core.util.mat.Vec3;

public class OBB {
    public final Vec3 center;
    public final Vec3[] points;
    public final Vec3[] normals;
    public final AxisAlignedBB aabb;

    public OBB(AxisAlignedBB aabb, Matrix3 matrix) {
        Vec3[] norms;
        this.center = new Vec3(aabb.func_189972_c());
        double xs2 = (aabb.field_72336_d - aabb.field_72340_a) / 2.0;
        double ys2 = (aabb.field_72337_e - aabb.field_72338_b) / 2.0;
        double zs2 = (aabb.field_72334_f - aabb.field_72339_c) / 2.0;
        Vec3 a = new Vec3(aabb.field_72336_d - aabb.field_72340_a, 0.0, 0.0).transform(matrix);
        Vec3 b = new Vec3(0.0, aabb.field_72337_e - aabb.field_72340_a, 0.0).transform(matrix);
        Vec3 c = new Vec3(0.0, 0.0, aabb.field_72334_f - aabb.field_72339_c).transform(matrix);
        Vec3[] points = new Vec3[]{new Vec3(xs2, ys2, zs2).transform(matrix).add(this.center), new Vec3(-xs2, ys2, zs2).transform(matrix).add(this.center), new Vec3(-xs2, -ys2, zs2).transform(matrix).add(this.center), new Vec3(-xs2, -ys2, -zs2).transform(matrix).add(this.center), new Vec3(xs2, ys2, -zs2).transform(matrix).add(this.center), new Vec3(xs2, -ys2, -zs2).transform(matrix).add(this.center), new Vec3(-xs2, ys2, -zs2).transform(matrix).add(this.center), new Vec3(xs2, -ys2, zs2).transform(matrix).add(this.center)};
        this.points = points;
        norms = new Vec3[]{a.crossProduct(b).normalize(), b.crossProduct(c).normalize(), c.crossProduct(a).normalize(), norms[0].inverse(), norms[1].inverse(), norms[2].inverse()};
        this.normals = norms;
        this.aabb = this.getAABB();
    }

    public OBB(AxisAlignedBB aabb) {
        this.center = new Vec3(aabb.func_189972_c());
        Vec3[] points = new Vec3[]{new Vec3(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f), new Vec3(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f), new Vec3(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f), new Vec3(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vec3(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c), new Vec3(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c), new Vec3(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c), new Vec3(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f)};
        this.points = points;
        Vec3[] norms = new Vec3[]{Vec3.ZP, Vec3.XP, Vec3.YP, Vec3.ZN, Vec3.XN, Vec3.YN};
        this.normals = norms;
        this.aabb = aabb;
    }

    private AxisAlignedBB getAABB() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (Vec3 point : this.points) {
            minX = Math.min(minX, point.x);
            minY = Math.min(minY, point.y);
            minZ = Math.min(minZ, point.z);
            maxX = Math.max(maxX, point.x);
            maxY = Math.max(maxY, point.y);
            maxZ = Math.max(maxZ, point.z);
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

