/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.data.capability;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.skds.core.api.IChunkData;
import net.skds.core.util.Class2InstanceMap;
import net.skds.core.util.SKDSUtils;
import net.skds.core.util.data.ChunkSectionAdditionalData;
import net.skds.core.util.data.capability.ChunkCapability;
import net.skds.core.util.interfaces.IChunkSectionExtended;

public class ChunkCapabilityData
implements ICapabilitySerializable<CompoundNBT> {
    private static RegEntry[] REGISTER = new RegEntry[0];
    public final Chunk chunk;
    private final ChunkSectionAdditionalData[] data;
    private final Class2InstanceMap<IChunkData> DATA = new Class2InstanceMap();

    public ChunkCapabilityData(Chunk chunk) {
        this.chunk = chunk;
        this.data = new ChunkSectionAdditionalData[chunk.func_76587_i().length];
        World w = chunk.func_177412_p();
        if (!w.field_72995_K) {
            this.createDefault();
        }
        for (RegEntry entry : REGISTER) {
            IChunkData dat;
            if (entry.side != SKDSUtils.Side.BOTH && (entry.side != SKDSUtils.Side.SERVER || w.field_72995_K) && (entry.side != SKDSUtils.Side.CLIENT || !w.field_72995_K) || (dat = entry.sup.sypply(this, entry.side)) == null) continue;
            this.DATA.put(dat);
        }
    }

    public void onUnload() {
        for (ChunkSectionAdditionalData c : this.data) {
            c.onUnload();
        }
        this.DATA.iterate(d -> d.onUnload());
    }

    private void createDefault() {
        ChunkSection[] sections = this.chunk.func_76587_i();
        for (int i = 0; i < this.data.length; ++i) {
            if (sections[i] == null) continue;
            this.data[i] = this.getCSAD(i, true);
        }
    }

    public void write(PacketBuffer buffer) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != null) {
                buffer.writeByte(17);
                this.data[i].write(buffer);
                continue;
            }
            buffer.writeByte(34);
        }
        this.DATA.iterate(d -> d.write(buffer));
    }

    public int getSize() {
        int i = this.data.length;
        for (ChunkSectionAdditionalData d2 : this.data) {
            if (d2 == null) continue;
            i += d2.getSize();
        }
        AtomicInteger ai = new AtomicInteger(i);
        this.DATA.iterate(d -> ai.addAndGet(d.getSize()));
        return ai.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void read(PacketBuffer buffer) {
        for (int i = 0; i < this.data.length; ++i) {
            if (buffer.readByte() != 17) continue;
            this.getCSAD(i, true).read(buffer);
        }
        this.DATA.iterate(d -> d.read(buffer));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            CompoundNBT nbt2 = new CompoundNBT();
            this.data[i].serialize(nbt2);
            nbt.func_218657_a(Integer.toString(i), (INBT)nbt2);
        }
        this.DATA.iterate(d -> d.serialize(nbt));
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        for (int i = 0; i < this.data.length; ++i) {
            CompoundNBT nbt2 = nbt.func_74775_l(Integer.toString(i));
            if (nbt2.isEmpty()) continue;
            this.getCSAD(i, true).deserialize(nbt2);
        }
        this.DATA.iterate(d -> d.deserialize(nbt));
    }

    public ChunkSectionAdditionalData getCSAD(int index, boolean create) {
        ChunkSection[] sections = this.chunk.func_76587_i();
        if (sections[index] == null && create) {
            sections[index] = new ChunkSection(index << 4);
        }
        if (this.data[index] == null && create) {
            this.data[index] = new ChunkSectionAdditionalData(this.chunk, index);
            IChunkSectionExtended.setData(this.data[index], sections[index]);
        }
        return this.data[index];
    }

    public int getCSADSize() {
        return this.data.length;
    }

    public <T extends IChunkData> IChunkData getCData(Class<T> type) {
        return (IChunkData)this.DATA.get(type);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ChunkCapability.CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    public static Optional<ChunkCapabilityData> getCap(Chunk chunk) {
        return chunk.getCapability(ChunkCapability.CAPABILITY).resolve();
    }

    public static boolean apply(Chunk chunk, Consumer<ChunkCapabilityData> cons) {
        Optional<ChunkCapabilityData> op = ChunkCapabilityData.getCap(chunk);
        if (op.isPresent()) {
            cons.accept(op.get());
            return true;
        }
        return false;
    }

    public static void register(IChunkDataSupplyer func, SKDSUtils.Side side) {
        RegEntry entry = new RegEntry(func, side);
        REGISTER = Arrays.copyOf(REGISTER, REGISTER.length + 1);
        ChunkCapabilityData.REGISTER[ChunkCapabilityData.REGISTER.length - 1] = entry;
    }

    public static interface IChunkDataSupplyer {
        public IChunkData sypply(ChunkCapabilityData var1, SKDSUtils.Side var2);
    }

    private static class RegEntry {
        public final SKDSUtils.Side side;
        public final IChunkDataSupplyer sup;

        RegEntry(IChunkDataSupplyer func, SKDSUtils.Side side) {
            this.side = side;
            this.sup = func;
        }
    }
}

