/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.data;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.skds.core.api.IChunkSectionData;
import net.skds.core.util.Class2InstanceMap;
import net.skds.core.util.SKDSUtils;
import net.skds.core.util.data.capability.ChunkCapabilityData;

public class ChunkSectionAdditionalData {
    private static RegEntry[] REGISTER = new RegEntry[0];
    private final Class2InstanceMap<IChunkSectionData> DATA = new Class2InstanceMap();
    public final World world;
    public final Chunk chunk;
    public final int secTndex;

    public ChunkSectionAdditionalData(Chunk chunk, int index) {
        this.secTndex = index;
        this.chunk = chunk;
        this.world = chunk.func_177412_p();
        SKDSUtils.Side actualSide = this.world.field_72995_K ? SKDSUtils.Side.CLIENT : SKDSUtils.Side.SERVER;
        for (RegEntry entry : REGISTER) {
            IChunkSectionData dat;
            if (entry.side != SKDSUtils.Side.BOTH && entry.side != actualSide || (dat = entry.sup.sypply(this, actualSide)) == null) continue;
            this.DATA.put(dat);
        }
    }

    public <T extends IChunkSectionData> T getData(Class<T> type) {
        return (T)((IChunkSectionData)this.DATA.get(type));
    }

    public void onUnload() {
        this.DATA.iterate(d -> d.onUnload());
    }

    public void tick() {
        this.DATA.iterate(d -> d.tick());
    }

    public void serialize(CompoundNBT nbt) {
        this.DATA.iterate(d -> d.serialize(nbt));
    }

    public void deserialize(CompoundNBT nbt) {
        this.DATA.iterate(d -> d.deserialize(nbt));
    }

    public void read(PacketBuffer buff) {
        this.DATA.iterate(d -> d.read(buff));
    }

    public void write(PacketBuffer buff) {
        this.DATA.iterate(d -> d.write(buff));
    }

    public boolean isClient() {
        return this.world.field_72995_K;
    }

    public int getSize() {
        AtomicInteger s = new AtomicInteger();
        this.DATA.iterate(d -> s.addAndGet(d.getSize()));
        return s.get();
    }

    public static ChunkSectionAdditionalData get(Chunk chunk, int index) {
        Optional<ChunkCapabilityData> op = ChunkCapabilityData.getCap(chunk);
        if (op.isPresent()) {
            ChunkCapabilityData dat = op.get();
            return dat.getCSAD(index, false);
        }
        return null;
    }

    public static <T extends IChunkSectionData> T getTyped(Chunk chunk, int index, Class<T> type) {
        ChunkSectionAdditionalData csad = ChunkSectionAdditionalData.get(chunk, index);
        if (csad != null) {
            return csad.getData(type);
        }
        return null;
    }

    public static void register(IChunkSectionDataSupplyer func, SKDSUtils.Side side) {
        RegEntry entry = new RegEntry(func, side);
        REGISTER = Arrays.copyOf(REGISTER, REGISTER.length + 1);
        ChunkSectionAdditionalData.REGISTER[ChunkSectionAdditionalData.REGISTER.length - 1] = entry;
    }

    public static interface IChunkSectionDataSupplyer {
        public IChunkSectionData sypply(ChunkSectionAdditionalData var1, SKDSUtils.Side var2);
    }

    private static class RegEntry {
        public final SKDSUtils.Side side;
        public final IChunkSectionDataSupplyer sup;

        RegEntry(IChunkSectionDataSupplyer func, SKDSUtils.Side side) {
            this.side = side;
            this.sup = func;
        }
    }
}

