/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.configs;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.minecraft.resources.DataPackRegistries;
import net.skds.core.SKDSCore;
import net.skds.core.api.IJsonConfigUnit;

public class UniversalJsonReader {
    public static DataPackRegistries DATA_PACK_RREGISTRIES = null;

    public DataPackRegistries getDPR() {
        return DATA_PACK_RREGISTRIES;
    }

    public static boolean read(IJsonConfigUnit unit) {
        File configDir = new File(unit.getPath());
        try {
            configDir.mkdirs();
            File readFile = new File(configDir, unit.getFormatedName());
            boolean exsists = readFile.exists();
            if (!exsists) {
                UniversalJsonReader.create(unit);
            }
            if (!UniversalJsonReader.interpret(unit, readFile)) {
                if (!exsists) {
                    return false;
                }
                UniversalJsonReader.create(unit);
                if (!UniversalJsonReader.interpret(unit, readFile)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean readResource(IJsonConfigUnit unit, InputStream is) {
        try {
            if (!UniversalJsonReader.interpretResource(unit, is)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean interpret(IJsonConfigUnit unit, File reading) throws IOException {
        JsonObject jsonobject = new JsonObject();
        FileInputStream inputStream = new FileInputStream(reading);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        JsonReader jsonReader = new JsonReader((Reader)r);
        Gson GSON = new Gson();
        try {
            jsonobject = (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
        }
        catch (IOException e) {
            SKDSCore.LOGGER.error("Empty or invalid config file! " + unit.getFormatedName());
            ((InputStream)inputStream).close();
            UniversalJsonReader.create(unit);
            inputStream = new FileInputStream(reading);
            r = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            jsonReader = new JsonReader((Reader)r);
            jsonobject = (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
        }
        ((Reader)r).close();
        jsonReader.close();
        return unit.apply(jsonobject);
    }

    private static boolean interpretResource(IJsonConfigUnit unit, InputStream inputStream) throws IOException {
        JsonObject jsonobject = new JsonObject();
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        JsonReader jsonReader = new JsonReader((Reader)r);
        Gson GSON = new Gson();
        try {
            jsonobject = (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
        }
        catch (IOException e) {
            SKDSCore.LOGGER.error("Empty or invalid config data file! " + unit.getFormatedName());
            ((Reader)r).close();
            jsonReader.close();
            return false;
        }
        ((Reader)r).close();
        jsonReader.close();
        return unit.apply(jsonobject);
    }

    private static boolean create(IJsonConfigUnit unit) throws IOException {
        BufferedInputStream is = new BufferedInputStream(unit.getClass().getClassLoader().getResourceAsStream(unit.getJarPath() + "/" + unit.getFormatedName()));
        File configFile = new File(unit.getPath(), unit.getFormatedName());
        if (configFile.exists()) {
            UniversalJsonReader.backup(unit);
        }
        Files.copy(is, configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    private static boolean backup(IJsonConfigUnit unit) throws IOException {
        File configFile = new File(unit.getPath(), unit.getFormatedName());
        File backupFile = new File(unit.getPath(), unit.getName() + "-backup." + unit.getFormat());
        int index = 0;
        while (backupFile.exists()) {
            backupFile = new File(unit.getPath(), unit.getName() + "-backup (" + ++index + ") ." + unit.getFormat());
        }
        SKDSCore.LOGGER.error("Creating config backup" + unit.getFormatedName());
        Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return true;
    }
}

