/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.blockupdate;

import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.skds.core.api.IWWS;
import net.skds.core.api.IWorldExtended;
import net.skds.core.api.multithreading.ITaskRunnable;
import net.skds.core.events.OnWWSAttachEvent;
import net.skds.core.util.Class2InstanceMap;
import net.skds.core.util.data.ChunkSectionAdditionalData;

public class WWSGlobal {
    private static List<WWSGlobal> INSTANCES = new ArrayList<WWSGlobal>();
    public final World world;
    private Set<BlockPos> players = new HashSet<BlockPos>();
    private Class2InstanceMap<IWWS> WWS = new Class2InstanceMap();
    private ConcurrentSet<Long> banPos = new ConcurrentSet();
    private ConcurrentSet<Long> banPosOld = new ConcurrentSet();

    public WWSGlobal(World w) {
        this.world = w;
        MinecraftForge.EVENT_BUS.post((Event)new OnWWSAttachEvent(w, this));
        INSTANCES.add(this);
    }

    public static WWSGlobal get(World world) {
        return ((IWorldExtended)world).getWWS();
    }

    private void bpClean() {
        this.banPos.removeAll(this.banPosOld);
        this.banPosOld.clear();
        this.banPosOld.addAll(this.banPos);
    }

    public void addWWS(IWWS wws) {
        this.WWS.put(wws);
    }

    public void stop() {
        this.WWS.iterate(wws -> wws.close());
    }

    public void tickIn() {
        this.updatePlayers();
        this.bpClean();
        this.WWS.iterate(wws -> wws.tickIn());
    }

    public void tickOut() {
        this.WWS.iterate(wws -> wws.tickOut());
    }

    private void updatePlayers() {
        List playersss = this.world.func_217369_A();
        HashSet<BlockPos> np = new HashSet<BlockPos>();
        for (PlayerEntity p : playersss) {
            BlockPos pos = p.func_233580_cy_();
            np.add(pos);
        }
        this.players = np;
    }

    public double getSqDistToNBP(BlockPos pos) {
        double dist = 1.0E20;
        for (BlockPos pos2 : this.players) {
            double dx = pos.func_177958_n() - pos2.func_177958_n();
            double dz = pos.func_177952_p() - pos2.func_177952_p();
            dist = Math.min(dist, dx * dx + dz * dz);
        }
        return dist;
    }

    public <T extends IWWS> T getTyped(Class<T> type) {
        return (T)((IWWS)this.WWS.get(type));
    }

    public void unloadWorld(World w) {
        INSTANCES.remove(this);
        this.stop();
    }

    public boolean unbanPos(long pos) {
        return this.banPos.remove((Object)pos);
    }

    public boolean banPos(long pos) {
        boolean ss = this.banPos.add((Object)pos);
        return ss;
    }

    public boolean isPosReady(long pos) {
        return !this.banPos.contains((Object)pos);
    }

    public static void tickPostMTH() {
        INSTANCES.forEach(wwsg -> wwsg.WWS.iterate(w -> w.tickPostMTH()));
    }

    public static void tickPreMTH() {
        INSTANCES.forEach(wwsg -> wwsg.WWS.iterate(w -> w.tickPreMTH()));
    }

    public static class TickSectionTask
    implements ITaskRunnable {
        private final ChunkSectionAdditionalData csad;

        public TickSectionTask(ChunkSectionAdditionalData csad) {
            this.csad = csad;
        }

        @Override
        public void run() {
            this.csad.tick();
        }

        @Override
        public boolean revoke(World w) {
            return false;
        }

        @Override
        public double getPriority() {
            return -1000000.0;
        }

        @Override
        public int getSubPriority() {
            return 0;
        }
    }
}

