/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.skds.core.SKDSCore;

public class SKDSUtils {
    private static final long[] BITS = new long[64];

    public static byte getByteBit(int i) {
        return (byte)BITS[i];
    }

    public static int getIntBit(int i) {
        return (int)BITS[i];
    }

    public static long getLingBit(int i) {
        return BITS[i];
    }

    public static FluidState readFluidState(CompoundNBT tag) {
        if (!tag.func_150297_b("Name", 8)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.func_74779_i("Name")));
        FluidState fluidState = fluid.func_207188_f();
        if (tag.func_150297_b("Properties", 10)) {
            CompoundNBT compoundnbt = tag.func_74775_l("Properties");
            StateContainer statecontainer = fluid.func_207182_e();
            for (String s : compoundnbt.func_150296_c()) {
                Property property = statecontainer.func_185920_a(s);
                if (property == null) continue;
                fluidState = SKDSUtils.setValueHelper(fluidState, property, s, compoundnbt, tag);
            }
        }
        return fluidState;
    }

    public static CompoundNBT writeFluidState(FluidState fs) {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("Name", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fs.func_206886_c()).toString());
        ImmutableMap immutablemap = fs.func_206871_b();
        if (!immutablemap.isEmpty()) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            for (Map.Entry entry : immutablemap.entrySet()) {
                Property property = (Property)entry.getKey();
                compoundnbt1.func_74778_a(property.func_177701_a(), SKDSUtils.getName(property, (Comparable)entry.getValue()));
            }
            compoundnbt.func_218657_a("Properties", (INBT)compoundnbt1);
        }
        return compoundnbt;
    }

    private static <T extends Comparable<T>> String getName(Property<T> p, Comparable<?> c) {
        return p.func_177702_a(c);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S s, Property<T> p, String name, CompoundNBT nbt, CompoundNBT nbt2) {
        Optional optional = p.func_185929_b(nbt.func_74779_i(name));
        if (optional.isPresent()) {
            return (S)((StateHolder)s.func_206870_a(p, (Comparable)optional.get()));
        }
        SKDSCore.LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)name, (Object)nbt.func_74779_i(name), (Object)nbt2.toString());
        return s;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            SKDSUtils.BITS[i] = 1L << i;
        }
    }

    public static enum Side {
        CLIENT,
        SERVER,
        BOTH;

    }
}

