/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util;

import java.util.Arrays;
import java.util.function.BiConsumer;

public class Object2ObjectMap<K, V> {
    private Object[] values = new Object[0];

    public void put(K key, V value) {
        if (value == null) {
            return;
        }
        for (Object o : this.values) {
            Entry e = (Entry)o;
            if (e.key != value.getClass()) continue;
            e.value = value;
            return;
        }
        int index = this.values.length;
        this.resize(index + 1);
        this.values[index] = new Entry(key, value);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public int containIndex(K c) {
        for (int i = 0; i < this.values.length; ++i) {
            if (((Entry)this.values[i]).key != c) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(K c) {
        return this.containIndex(c) != -1;
    }

    public <T extends V> T get(K c) {
        if (this.values.length > 0) {
            for (Object o : this.values) {
                Entry e = (Entry)o;
                if (e.key != c) continue;
                return (T)e.value;
            }
        }
        return null;
    }

    private void resize(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    public void remove(K c) {
        if (this.values.length > 0) {
            int n = this.containIndex(c);
            if (n == -1) {
                return;
            }
            Object[] a1 = new Object[this.values.length - 1];
            int i2 = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (i == n) continue;
                a1[i2] = this.values[i];
                ++i2;
            }
            this.values = a1;
        }
    }

    public void iterate(BiConsumer<K, V> consumer) {
        for (Object o : this.values) {
            Entry e = (Entry)o;
            consumer.accept(e.key, e.value);
        }
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    private class Entry {
        public K key;
        public V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format("{%s=%s} ", this.key, this.value);
        }
    }
}

