/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util;

import java.util.Arrays;
import java.util.function.Consumer;

public class Class2InstanceMap<T> {
    private Object[] values = new Object[0];

    public void put(T value) {
        if (value == null) {
            return;
        }
        for (Object o : this.values) {
            Entry e = (Entry)o;
            if (e.clazz != value.getClass()) continue;
            e.instance = value;
            return;
        }
        int index = this.values.length;
        this.resize(index + 1);
        this.values[index] = new Entry(value);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public int containIndex(Class<? extends T> c) {
        for (int i = 0; i < this.values.length; ++i) {
            if (((Entry)this.values[i]).clazz != c) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Class<? extends T> c) {
        return this.containIndex(c) != -1;
    }

    public <V extends T> V get(Class<V> c) {
        if (this.values.length > 0) {
            for (Object o : this.values) {
                Entry e = (Entry)o;
                if (e.clazz != c) continue;
                return (V)e.instance;
            }
        }
        return null;
    }

    private void resize(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    public void remove(Class<? extends T> c) {
        if (this.values.length > 0) {
            int n = this.containIndex(c);
            if (n == -1) {
                return;
            }
            Object[] a1 = new Object[this.values.length - 1];
            int i2 = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (i == n) continue;
                a1[i2] = this.values[i];
                ++i2;
            }
            this.values = a1;
        }
    }

    public void iterate(Consumer<T> consumer) {
        for (Object o : this.values) {
            Entry e = (Entry)o;
            consumer.accept(e.instance);
        }
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    private class Entry {
        public Class<T> clazz;
        public T instance;

        Entry(T instance) {
            this.clazz = instance.getClass();
            this.instance = instance;
        }

        public String toString() {
            return String.format("{%s=%s} ", this.clazz, this.instance);
        }
    }
}

