/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.multithreading;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.skds.core.api.IServerChunkProvider;

public class TurboWorldReader {
    public final BlockState nullreturnstate = Blocks.field_150350_a.func_176223_P();
    public final FluidState nullreturnFstate = Fluids.field_204541_a.func_207188_f();
    public final World world;
    private IChunk chunkCash = null;
    private long chunkPosCash = 0L;
    private boolean newChunkCash = true;
    public final boolean isClient;

    public TurboWorldReader(World world) {
        this.isClient = world.field_72995_K;
        this.world = world;
    }

    public IChunk getIChunk(int blockX, int blockZ) {
        long lpos = ChunkPos.func_77272_a((int)(blockX >> 4), (int)(blockZ >> 4));
        if (this.newChunkCash || lpos != this.chunkPosCash) {
            this.newChunkCash = false;
            AbstractChunkProvider prov = this.world.func_72863_F();
            this.chunkCash = this.isClient ? prov.func_225313_a(blockX >> 4, blockZ >> 4) : ((IServerChunkProvider)prov).getCustomChunk(lpos);
            this.chunkPosCash = lpos;
        }
        return this.chunkCash;
    }

    public IChunk getIChunk(BlockPos pos) {
        return this.getIChunk(pos.func_177958_n(), pos.func_177952_p());
    }

    public Chunk getChunk(BlockPos pos) {
        IChunk iChunk = this.getIChunk(pos);
        if (iChunk != null && iChunk instanceof Chunk) {
            return (Chunk)iChunk;
        }
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        IChunk chunk = this.getIChunk(pos);
        if (chunk == null) {
            return this.nullreturnstate;
        }
        BlockState ssss = chunk.func_180495_p(pos);
        if (ssss == null) {
            return this.nullreturnstate;
        }
        return ssss;
    }

    public FluidState getFluidState(BlockPos pos) {
        IChunk chunk = this.getIChunk(pos);
        if (chunk == null) {
            return this.nullreturnFstate;
        }
        FluidState ssss = chunk.func_204610_c(pos);
        if (ssss == null) {
            return this.nullreturnFstate;
        }
        return ssss;
    }

    public ChunkSection getChunkSection(BlockPos pos, boolean create) {
        Chunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return null;
        }
        int y = pos.func_177956_o();
        if (y < 0 || y > 255) {
            return null;
        }
        ChunkSection[] chunksections = chunk.func_76587_i();
        ChunkSection sec = chunksections[y >> 4];
        if (sec == null && create) {
            chunksections[y >> 4] = sec = new ChunkSection(y >> 4 << 4);
        }
        return sec;
    }

    public TileEntity getTileEntity(BlockPos pos) {
        Chunk ch = this.getChunk(pos);
        TileEntity tileentity = null;
        if (ch != null) {
            tileentity = ch.func_177424_a(pos, Chunk.CreateEntityType.IMMEDIATE);
        }
        return tileentity;
    }

    public static Set<BlockPos> getBlockPoses(AxisAlignedBB aabb) {
        int x0 = (int)Math.floor(aabb.field_72340_a);
        int y0 = (int)Math.floor(aabb.field_72338_b);
        int z0 = (int)Math.floor(aabb.field_72339_c);
        int x2 = (int)Math.ceil(aabb.field_72336_d);
        int y2 = (int)Math.ceil(aabb.field_72337_e);
        int z2 = (int)Math.ceil(aabb.field_72334_f);
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int x = x0; x <= x2; ++x) {
            for (int y = y0; y <= y2; ++y) {
                for (int z = z0; z <= z2; ++z) {
                    set.add(new BlockPos(x, y, z));
                }
            }
        }
        return set;
    }

    public static boolean isAir(BlockState state) {
        return state.func_185904_a() == Material.field_151579_a;
    }
}

