/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.multithreading;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.skds.core.multithreading.TurboWorldReader;

public class TurboWorldEditor {
    public final BlockState nullreturnstate = Blocks.field_150350_a.func_176223_P();
    public final TurboWorldReader reader;
    public final Action<BlockPos, BlockState, BlockState, World> action;

    public TurboWorldEditor(TurboWorldReader reader, Action<BlockPos, BlockState, BlockState, World> act) {
        this.reader = reader;
        this.action = act;
    }

    public BlockState setState(BlockPos pos, BlockState newState) {
        BlockState oldState = this.setMaskedBlockState(pos, newState);
        if (oldState == null) {
            return this.nullreturnstate;
        }
        this.action.applyAction(pos, newState, oldState, this.reader.world);
        return oldState;
    }

    public BlockState setMaskedBlockState(BlockPos pos, BlockState state) {
        Chunk chunk = this.reader.getChunk(pos);
        if (chunk == null) {
            return null;
        }
        int y = pos.func_177956_o();
        if (y < 0 || y > 255) {
            return null;
        }
        ChunkSection[] chunksections = chunk.func_76587_i();
        ChunkSection sec = chunksections[y >> 4];
        if (sec == null) {
            chunksections[y >> 4] = sec = new ChunkSection(y >> 4 << 4);
        }
        BlockState setted = sec.func_222629_a(pos.func_177958_n() & 0xF, y & 0xF, pos.func_177952_p() & 0xF, state);
        return setted;
    }

    public static interface Action<P extends BlockPos, A extends BlockState, B extends BlockState, W extends World> {
        public void applyAction(P var1, A var2, B var3, W var4);
    }
}

