/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.multithreading;

import java.util.function.Function;
import net.skds.core.api.multithreading.ITaskRunnable;
import net.skds.core.multithreading.UniversalWorkerThread;

public class ThreadProvider {
    public static int PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static UniversalWorkerThread[] THREADS = UniversalWorkerThread.create(PROCESSORS);

    public static void doSyncFork(Function<Integer, ITaskRunnable> sup) {
        for (UniversalWorkerThread t : THREADS) {
            t.forkSync(sup);
        }
    }

    public static void waitForStop() throws InterruptedException {
        while (!ThreadProvider.isDone()) {
            Thread.yield();
        }
    }

    public static boolean isDone() {
        for (UniversalWorkerThread t : THREADS) {
            if (t.isDone()) continue;
            return false;
        }
        return true;
    }
}

